#include "soubi.h"
#include "soubislot.h"
#include <QDebug>

QMultiMap<int, QString> Soubi::_buiKindsMap = QMultiMap<int, QString>();

Soubi::Soubi(QString name,
             Data *parent,
             QVector<QString> property)
                 :Data(name, parent),
                 _purchaseCost(),
                 _regularCost(),
                 _part(),
                 _partIndex(0),
                 _capabilityType(),
                 _capabilityValue(),
                 _koudouValue(),
                 _koudouMark(),
                 _damage(),
                 _hp(),
                 _range(),
                 _detail(),
                 _reference(),
                 _property(property)
{
    _property.replace(0, name);
}

Soubi::~Soubi()
{
}

Soubi* Soubi::GetSoubi()
{
    return this;
}

QString Soubi::GetPurchaseCost()
{
    return _property.at(1);
}

bool Soubi::SetPurchaseCost(QString value)
{
    _property.replace(1, value);
    return true;
}

QString Soubi::GetRegularCost()
{
    return _property.at(2);
}

bool Soubi::SetRegularCost(QString value)
{
    _property.replace(2, value);
    return true;
}

QString Soubi::GetPart()
{
    return _property.at(3);
}

bool Soubi::SetPart(QString part)
{
    _property.replace(3, part);
    for(unsigned short i=0;i<getSoubiSlot()->at(0)->getBuiSize();++i)
    {
        if(getSoubiSlot()->at(0)->getBuiNamesVector(i).contains(part))
        {
            _partIndex = i;
        }
    }
    return true;
}

QString Soubi::GetCapability()
{
    return _property.at(4);
}

bool Soubi::SetCapability(QString type)
{
    _property.replace(4, type);
    return true;
}

QString Soubi::GetKoudou()
{
    return _property.at(5);
}

bool Soubi::SetKoudou(QString koudou)
{
    _property.replace(5, koudou);
    return true;
}

QString Soubi::GetDamage()
{
    return _property.at(6);
}

bool Soubi::SetDamage(QString damage)
{
    _property.replace(6, damage);
    return true;
}

QString Soubi::GetHP()
{
    return _property.at(7);
}

bool Soubi::SetHP(QString hp)
{
    _property.replace(7, hp);
    return true;
}

QString Soubi::GetRange()
{
    return _property.at(8);
}

bool Soubi::SetRange(QString range)
{
    _property.replace(8, range);
    return true;
}

QString Soubi::GetDetail()
{
    return _property.at(9);
}

bool Soubi::SetDetail(QString detail)
{
    _property.replace(9, detail);
    return true;
}

QString Soubi::GetReference()
{
    return _property.at(10);
}

bool Soubi::SetReference(QString reference)
{
    _property.replace(10, reference);
    return true;
}

QVector<QString> Soubi::GetProperty()
{
    return _property;
}

/**
  指標に部位の略称を追加する
  */
bool Soubi::addBuiKind(unsigned short i, QString str)
{
    _buiKindsMap.insert(i, str);
    return true;
}

/**
  指定された指標に該当する部位か判別する
  */
bool Soubi::checkBuiKind(unsigned short i)
{
    if(_buiKindsMap.find(i, GetPart()) == _buiKindsMap.end() )
    {
        return false;
    }
    else
    {
        return true;
    }
}
