#ifndef SOUBI_H
#define SOUBI_H
#include "data.h"

class Soubi : public Data
{
public:
    Soubi(QString name = QString(""),
          Data *parent = NULL,
          QVector<QString> property = QVector<QString>(11, QString("")));
    virtual ~Soubi();
    virtual Soubi* GetSoubi();

    virtual QString GetPurchaseCost();
    virtual bool SetPurchaseCost(QString value);
    virtual QString GetRegularCost();
    virtual bool SetRegularCost(QString value);
    virtual QString GetPart();
    virtual bool SetPart(QString part);
    virtual QString GetCapability();
    virtual bool SetCapability(QString value);
    virtual QString GetKoudou();
    virtual bool SetKoudou(QString koudou);
    virtual QString GetDamage();
    virtual bool SetDamage(QString damage);
    virtual QString GetHP();
    virtual bool SetHP(QString hp);
    virtual QString GetRange();
    virtual bool SetRange(QString range);
    virtual QString GetDetail();
    virtual bool SetDetail(QString detail);
    virtual QString GetReference();
    virtual bool SetReference(QString reference);

    virtual QVector<QString> GetProperty();
    static bool addBuiKind(unsigned short i, QString str);
    virtual bool checkBuiKind(unsigned short i);

private:
    QString _purchaseCost;
    QString _regularCost;
    QString _part;
    unsigned short _partIndex;
    QString _capabilityType;
    QString _capabilityValue;
    QString _koudouValue;
    QString _koudouMark;
    QString _damage;
    QString _hp;
    QString _range;
    QString _detail;
    QString _reference;
    QVector<QString> _property;
    static QMultiMap<int, QString> _buiKindsMap;
};

#endif // SOUBI_H
