#include "soubidatainterpreter.h"
#include <QMessageBox>
#include <QDebug>
#include "soubislot.h"

SoubiDataInterpreter::SoubiDataInterpreter()
    :_soubi()
{
}

Data* SoubiDataInterpreter::Interpret(QList<QString> list, Data *parent)
{
    try
    {
        _soubi = new Soubi(list.at(0), parent, list.toVector());

        parent->Add(_soubi);

        //部位の数だけ回す
        for(unsigned short i=0;i<SoubiSlot::getBuiSize();++i)
        {
            //装備がこの部位に合致する場合か、最後まで合致しない即ち一般装備の場合
            if( (_soubi->checkBuiKind(i)) || (i==SoubiSlot::getBuiSize()-1) )
            {
                //分類に装備データ
                parent->addSoubiOfBui(i, _soubi);
                //部位に装備データ
                SoubiSlot::addEachBuiSoubi(i, _soubi);
                break;
            }
        }

        //分類の持つ装備テーブルウィジェット
        //分類列探索
        int baseColumn = -1;
        QTableWidget* stw = parent->getSoubiTableWidget();
        for(int k=0;k<stw->columnCount();++k)
        {
            if( stw->horizontalHeaderItem(k)->text().contains(QObject::tr("分類")) )
            {
                baseColumn = k;
                break;
            }
        }
        if(baseColumn==-1)
        {
            throw QObject::tr("分類列が見つかりません");
        }

        stw->setRowCount(stw->rowCount()+1);
        int row = stw->rowCount() -1;
        //分類名
        stw->setItem(row, 0, new QTableWidgetItem( parent->GetName(), 0) );
        //装備の各要素
        for(int j=0;j<11;++j)
        {
            stw->setItem(row, j+1, new QTableWidgetItem( list.takeFirst(), 0 ) );
        }
        return _soubi;
    }
    catch(QString str)
    {
        QMessageBox::warning(NULL, QObject::tr("Warning"), str, QMessageBox::Ok, QMessageBox::NoButton);
        return NULL;
    }
}

Data* SoubiDataInterpreter::Interpret(QString str, Data *data)
{
    return NULL;
}
