#include <QMessageBox>
#include <QDebug>
#include "soubiform.h"
#include "ui_soubiform.h"

SoubiForm::SoubiForm(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::SoubiForm),
        _groupingList(),
        _ownGeneral(),
        _soubiSlot(),
        _visibleSoubiTableWidget(),
        _visibleSoubiTableList(),
        _generalSoubiList(new QList<Data*>())
{
    ui->setupUi(this);
    connect(ui->soubiTableWidget, SIGNAL(clicked(QModelIndex)), ui->soubiTableWidget, SLOT(resizeColumnsToContents()));
    connect(ui->generalSoubiTableWidget, SIGNAL(clicked(QModelIndex)), ui->generalSoubiTableWidget, SLOT(resizeColumnsToContents()));

    _visibleSoubiTableWidget = ui->soubiTableWidget;
    setTableResize();

    ui->removeSlotButton->setEnabled(false);
    ui->removeGeneralSoubiButton->setEnabled(false);
    ui->soubiAddButton->setEnabled(false);
}

SoubiForm::~SoubiForm()
{
    delete ui;
}

/**
  リサイズ
  */
bool SoubiForm::setTableResize()
{
    ui->groupingTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->soubiSlotTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    ui->generalSoubiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    return true;
}

/**
  general直下の分類を設定
  初期化処理
  */
bool SoubiForm::setOwnGeneral(Data *general)
{
    _ownGeneral = general;
    for(int i=0;general->GetChild(i)!=NULL;++i)
    {
        if(general->GetChild(i)->GetGrouping()!=NULL)
        {
            general->OwnAdd(general->GetChild(i));
        }
    }

    //全ての分類を表示
    addGrouping(general);
    //装備スロットで武器防具一般装備を取得できるようにする
    addSlotSoubiOfGroupingOf(general);
    //狭義の一般装備を取得できるようにする
    addGeneralSoubiOfGroupingOf(general);
    _visibleSoubiTableList = _generalSoubiList;
    return true;
}

/**
  data直下の分類を表示
  各分類以下の装備のテーブルウィジェットを挿入
  初期化処理
  */
bool SoubiForm::addGrouping(Data *data)
{
    QList<Grouping*> list;
    data->findAll(list);

    _groupingList.clear();

    foreach(Grouping* grouping, list)
    {
        _groupingList.append(grouping);
    }

    ui->groupingTableWidget->setRowCount(0);

    Data *grouping = NULL;
    QString parentsNames;
    QList<Data*> parentslist = QList<Data*>();

    for(int i=0;i<_groupingList.size();++i)
    {
        grouping = _groupingList.at(i);

        //分類名の表示
        ui->groupingTableWidget->setRowCount(ui->groupingTableWidget->rowCount() +1);
        ui->groupingTableWidget->setItem(ui->groupingTableWidget->rowCount() -1, 0, new QTableWidgetItem(grouping->GetName(), 0));

        //分類の所属しているものの名前表示
        parentsNames.clear();
        parentslist = grouping->GetParents();
        for(short i=0;i<parentslist.size();++i)
        {
            //複数の所属がある場合
            if(i>0)
            {
                parentsNames.append(tr("、"));
            }
            parentsNames.append(parentslist.at(i)->GetName());
        }
        ui->groupingTableWidget->setItem(ui->groupingTableWidget->rowCount() -1, 1, new QTableWidgetItem(parentsNames, 0));

        //ウィジェット挿入
        ui->tokugiVerticalLayout->insertWidget(ui->tokugiVerticalLayout->count() -1, grouping->getSoubiTableWidget() );
        grouping->getSoubiTableWidget()->hide();
    }

    return true;
}

/**
  取消カテゴリの分類を除去
  入力：カテゴリ
  出力：なし
  */
bool SoubiForm::removeGrouping(Data *data)
{
    QTableWidget *w;
    for(int i=0;data->GetChild(i)!=NULL;++i)
    {
        Data *grouping = data->GetChild(i)->GetGrouping();
        if(grouping!=NULL)
        {
            if(_visibleSoubiTableWidget == grouping->getSoubiTableWidget())
            {
                _visibleSoubiTableWidget->hide();
                _visibleSoubiTableWidget = ui->soubiTableWidget;
                _visibleSoubiTableWidget->show();
            }
            for(int j=0;j<_soubiSlot->size();++j)
            {
                w = _soubiSlot->at(0)->getPartSoubiTableWidget();
                //0:分類列
                for(int k=0;k<w->rowCount();)
                {
                    if(w->item(k, 0)->text()==grouping->GetName())
                    {
                        w->removeRow(k);
                        continue;
                    }
                    ++k;
                }
            }
            _groupingList.removeOne(grouping);
        }
    }
    return true;
}

/**
  選択装備のデータを取得
  入力：なし
  出力：選択装備データ
*/
Data* SoubiForm::getSelSoubi()
{
    try
    {
        return _visibleSoubiTableList->at(_visibleSoubiTableWidget->currentRow());
    }
    catch(QString str)
    {
        QMessageBox::warning(this, tr("Warning"), str, QMessageBox::Ok,QMessageBox::NoButton);
        return NULL;
    }
}

/**
  装備スロットウィジェット設定
  初期化処理
  */
bool SoubiForm::setSoubiSlot(QVector<SoubiSlot*> *slotVector)
{
    _soubiSlot = slotVector;
    ui->soubiSlotTableWidget->clearContents();
    ui->soubiSlotTableWidget->setRowCount(slotVector->size());
    //装備箇所ごとのテーブルウィジェット作成
    for(int i=0; i< slotVector->size();++i)
    {
        //装備箇所ごとの装備テーブルウィジェットの挿入
        ui->tokugiVerticalLayout->insertWidget(ui->tokugiVerticalLayout->count() -1, slotVector->at(i)->getPartSoubiTableWidget());
        slotVector->at(i)->getPartSoubiTableWidget()->hide();

        //装備スロットのテーブルウィジェットに装備箇所名を記入
        ui->soubiSlotTableWidget->setItem((int)i, 0, new QTableWidgetItem(slotVector->at(i)->getPartName()));
    }
    return true;
}

/**
  それぞれの装備箇所のテーブルウィジェットにdata以下の装備を付け加える
  */
bool SoubiForm::addSlotSoubiOfGroupingOf(Data *data)
{
    QTableWidget *w = NULL;
    QVector<QString> p = QVector<QString>();
    QList<unsigned short> list = QList<unsigned short>();

    //data以下の子データ
    for(unsigned short i=0;data->GetChild(i)!=NULL;++i)
    {
        Data *grouping = data->GetChild(i)->GetGrouping();
        if(grouping==NULL)
        {
            continue;
        }
        //装備箇所の数だけ回る
        for(unsigned short j=0;j<_soubiSlot->size();++j)
        {
            w = _soubiSlot->at(j)->getPartSoubiTableWidget();

            list = SoubiSlot::getPartAndBuiNumbersMap()->values(j);
            //この装備箇所に入る部位
            for(short k=list.size()-1;k>=0;--k)
            {
                //この部位である装備
                if(grouping->getSoubiOfBui(list.at(k))==NULL)
                {
                    continue;
                }
                for(unsigned short l=0;l<grouping->getSoubiOfBui(list.at(k))->size();++l)
                {
                    w->setRowCount(w->rowCount()+1);
                    w->setItem(w->rowCount() -1, 0, new QTableWidgetItem( grouping->GetName() ));

                    p = grouping->getSoubiOfBui(list.at(k))->at(l)->GetProperty();
                    //各装備の要素
                    //テーブルウィジェットに記入
                    for(int m=0;m<p.size();++m)
                    {
                        w->setItem(w->rowCount()-1, m+1, new QTableWidgetItem( p.at(m) ));
                    }

                    //各装備データをリストに格納
                    if(grouping->getSoubiOfBui(list.at(k))->value(l)!=NULL)
                    {
                        _soubiSlot->at(j)->addEachPartSoubi(grouping->getSoubiOfBui(list.at(k))->value(l));
                    }
                }
            }
        }
    }
    return true;
}

/**
  一般装備テーブルウィジェットにdata以下の装備を付け加える
*/
bool SoubiForm::addGeneralSoubiOfGroupingOf(Data *data)
{
    QTableWidget *w = NULL;
    QVector<QString> p = QVector<QString>();
    QList<Data*> *generalList = NULL;
    //data以下の子データ
    for(unsigned short i=0;data->GetChild(i)!=NULL;++i)
    {
        Data *grouping = data->GetChild(i)->GetGrouping();
        if(grouping==NULL)
        {
            continue;
        }
        generalList = grouping->getSoubiOfBui(SoubiSlot::getBuiSize()-1);
        if(generalList==NULL)
        {
            continue;
        }

        w = ui->soubiTableWidget;
        //一般装備の部位すなわち規定の物以外
        for(unsigned short l=0;l<generalList->size();++l)
        {
            w->setRowCount(w->rowCount()+1);
            w->setItem(w->rowCount() -1, 0, new QTableWidgetItem( grouping->GetName() ));

            p = generalList->at(l)->GetProperty();
            //各装備の要素
                //テーブルウィジェットに記入
            for(int m=0;m<p.size();++m)
            {
                w->setItem(w->rowCount()-1, m+1, new QTableWidgetItem( p.at(m) ));
            }

            //一般装備のデータリストにこの分類での一般装備のデータリストを加える
            _generalSoubiList->append(generalList->at(l));
        }
    }
    return true;
}

bool SoubiForm::removeSlotSoubiFromWidget(int i)
{
    //先頭は装備箇所名
    for(unsigned short j=1;j<12;++j)
    {
        ui->soubiSlotTableWidget->takeItem(i, j);
    }
    return true;
}

bool SoubiForm::removeGeneralSoubiFromWidget(int i)
{
    ui->generalSoubiTableWidget->removeRow(i);
    if(ui->generalSoubiTableWidget->rowCount()==0)
    {
        ui->generalSoubiTableWidget->setRowCount(1);
    }
    return true;
}

bool SoubiForm::setVisibleSoubiTableList(QList<Data *> *list)
{
    _visibleSoubiTableList = list;
    return true;
}

QList<Data*>* SoubiForm::getVisibleSoubiTableList()
{
    return _visibleSoubiTableList;
}

/*
 slots
 */

void SoubiForm::GetSelectedCorona(Data *corona)
{
    addSlotSoubiOfGroupingOf(corona);
    addGeneralSoubiOfGroupingOf(corona);
}

void SoubiForm::GetSelectedMeme(Data *meme)
{
    addSlotSoubiOfGroupingOf(meme);
    addGeneralSoubiOfGroupingOf(meme);
}

void SoubiForm::GetSelectedBranch(Data *branch)
{
    addSlotSoubiOfGroupingOf(branch);
    addGeneralSoubiOfGroupingOf(branch);
}

void SoubiForm::getRemovedCategory(Data *category)
{
    removeGrouping(category);
}

/**
  装備取得ボタン
  */
void SoubiForm::on_soubiAddButton_clicked()
{
    try
    {
        Data *soubi = getSelSoubi();
        QList<Data*> parentCategoryList = QList<Data*>();
        if(soubi == NULL) // soubi が null のエラー回避
        {
            throw tr("装備がありません");
        }

        parentCategoryList = soubi->GetParent()->GetParents();
        if(parentCategoryList.size()==0) // 装備の所属分類の所属カテゴリ群の有無をチェック
        {
            throw tr("装備が属しているものがありません");
        }

        bool isOwnable = false;
        foreach(Data* p, parentCategoryList)
        {
            if( (p->IsOwned()==true) || (p == _ownGeneral) )
            {
                isOwnable = true;
                p->OwnAdd(soubi);
                break;
            }
        }
        if(isOwnable==false) //所属元を取得していないならば
        {
            throw tr("装備が属しているものが取得されていません");
        }

        //装備スロットの場合
        if(_visibleSoubiTableWidget != ui->soubiTableWidget)
        {
            int row = ui->soubiSlotTableWidget->currentRow();
            //装備を置き換える場合
            if(_soubiSlot->at(row)->getSlotSoubi()!=NULL)
            {
                _soubiSlot->at(row)->getSlotSoubi()->GetParent()->OwnRemove(_soubiSlot->at(row)->getSlotSoubi());
                emit removeSlotSoubi(row);
            }
            _soubiSlot->at(row)->setSoubi(soubi);
            ui->soubiSlotTableWidget->setItem(row, 1, new QTableWidgetItem(soubi->GetName()));
            ui->soubiSlotTableWidget->setItem(row, 2, new QTableWidgetItem(soubi->GetParent()->GetName()));
            QVector<QString> p = soubi->GetProperty();
            for(unsigned short i=0;i<p.size()-1;++i)
            {
                ui->soubiSlotTableWidget->setItem(row, i+3, new QTableWidgetItem(p.at(i+1)));
            }
            //to MainWindow::GetSelectedSoubi
            emit getSlotSoubi(row, soubi);
        }
        //一般装備の場合
        else
        {
            unsigned short row = (ui->generalSoubiTableWidget->rowCount()==1) ? 0 : (ui->generalSoubiTableWidget->rowCount()-1);
            ui->generalSoubiTableWidget->setRowCount(ui->generalSoubiTableWidget->rowCount()+1);

            ui->generalSoubiTableWidget->setItem(row, 0, new QTableWidgetItem(soubi->GetName()));
            ui->generalSoubiTableWidget->setItem(row, 1, new QTableWidgetItem(soubi->GetParent()->GetName()));
            QVector<QString> p = soubi->GetProperty();
            for(unsigned short i=0;i<p.size()-1;++i)
            {
                ui->generalSoubiTableWidget->setItem(row, i+2, new QTableWidgetItem(p.at(i+1)));
            }

            //to MainWindow::GetSelectedSoubi
            emit getGeneralSoubi(row, soubi);
        }
    }
    catch(QString str)
    {
        QMessageBox::warning(this, tr("Warning"), str,QMessageBox::Ok,QMessageBox::NoButton);
    }
}

/**
  分類テーブルウィジェットクリック
  リサイズと分類に属する装備の表示
*/
void SoubiForm::on_groupingTableWidget_clicked(QModelIndex index)
{
    ui->groupingTableWidget->resizeColumnsToContents();

    _visibleSoubiTableWidget->hide();
    _visibleSoubiTableWidget = _groupingList.at(ui->groupingTableWidget->currentRow())->getSoubiTableWidget();
    _visibleSoubiTableWidget->show();

    ui->removeSlotButton->setEnabled(false);
    ui->removeGeneralSoubiButton->setEnabled(false);
    ui->soubiAddButton->setEnabled(false);
}

/**
  装備スロットクリック
  各部位に対応した装備テーブルウィジェットを表示
*/
void SoubiForm::on_soubiSlotTableWidget_cellClicked(int row, int column)
{
    if(row < _soubiSlot->size())
    {
        _visibleSoubiTableWidget->hide();
        _visibleSoubiTableWidget = _soubiSlot->at(row)->getPartSoubiTableWidget();
        _visibleSoubiTableWidget->show();
        _visibleSoubiTableWidget->resizeColumnsToContents();
        _visibleSoubiTableList = _soubiSlot->at(row)->getEachPartSoubi();

        if(_soubiSlot->at(row)->getSlotSoubi()==NULL)
        {
            ui->removeSlotButton->setEnabled(false);
        }
        else
        {
            ui->removeSlotButton->setEnabled(true);
        }
        ui->removeGeneralSoubiButton->setEnabled(false);
        ui->soubiAddButton->setEnabled(false);
    }
}

/**
  装備スロット装備解除ボタン
  */
void SoubiForm::on_removeSlotButton_clicked()
{
    try
    {
        int row = ui->soubiSlotTableWidget->currentRow();
        Data *soubi = _soubiSlot->at(row)->getSlotSoubi();
        if(soubi == NULL)
        {
            throw QObject::tr("装備がありません");
        }
        soubi->GetParent()->OwnRemove(soubi);
        removeSlotSoubiFromWidget(row);
        _soubiSlot->at(row)->setSoubi(NULL);
        emit removeSlotSoubi(row);
    }
    catch(QString str)
    {
        QMessageBox::warning(this, tr("Warning"), str,QMessageBox::Ok,QMessageBox::NoButton);
    }
}

/**
  一般装備テーブルウィジェットセルクリック
  */
void SoubiForm::on_generalSoubiTableWidget_cellClicked(int row, int column)
{
    ui->soubiTableWidget->resizeColumnsToContents();

    _visibleSoubiTableWidget->hide();
    _visibleSoubiTableWidget = ui->soubiTableWidget;
    _visibleSoubiTableWidget->show();
    _visibleSoubiTableList = _generalSoubiList;

    ui->removeSlotButton->setEnabled(false);
    ui->removeGeneralSoubiButton->setEnabled(true);
    ui->soubiAddButton->setEnabled(false);
}

/**
  取得可能装備テーブルウィジェットセルクリック
  */
void SoubiForm::on_soubiTableWidget_cellClicked(int row, int column)
{
    ui->generalSoubiTableWidget->resizeColumnsToContents();

    ui->removeSlotButton->setEnabled(false);
    ui->removeGeneralSoubiButton->setEnabled(false);
    ui->soubiAddButton->setEnabled(true);
}

/**
  取得可能装備テーブルウィジェットセルクリック
  SoubiSlotが保持しているウィジェット
  */
void SoubiForm::partSoubiTableWidget_cellClicked()
{
    _visibleSoubiTableWidget->resizeColumnsToContents();

    ui->removeSlotButton->setEnabled(false);
    ui->removeGeneralSoubiButton->setEnabled(false);
    ui->soubiAddButton->setEnabled(true);
}

/**
　　装備スロットテーブルウィジェットから該当装備の行の要素を削除
  from mainWindow
  */
void SoubiForm::removeSelectedSlotSoubi(int i)
{
    //removeSlotSoubiFromWidget(ui->soubiSlotTableWidget->currentRow());
    removeSlotSoubiFromWidget(i);
}

/**
  from MainWindow
  */
void SoubiForm::removeSelectedGeneralSoubi(int i)
{
    removeGeneralSoubiFromWidget(i);
}

/**
  一般装備解除ボタン
  */
void SoubiForm::on_removeGeneralSoubiButton_clicked()
{
    int row = ui->generalSoubiTableWidget->currentRow();
    //一番下の行すなわち空白行の場合
    if(row == ui->generalSoubiTableWidget->rowCount()-1)
    {
        return;
    }
    removeGeneralSoubiFromWidget(row);
    emit removeGeneralSoubi(row);
}
