#ifndef SOUBIFORM_H
#define SOUBIFORM_H

#include <QList>
#include <QWidget>
#include "data.h"
#include "grouping.h"
#include "soubi.h"
#include "categorywindow.h"
#include "soubislot.h"

namespace Ui {
    class SoubiForm;
}

class SoubiForm : public QWidget
{
    Q_OBJECT

public:
    explicit SoubiForm(QWidget *parent = 0);
    ~SoubiForm();

    virtual bool setTableResize();
    virtual bool setOwnGeneral(Data *general);
    virtual bool addGrouping(Data *data);
    virtual bool removeGrouping(Data *data);
    virtual Data* getSelSoubi();
    virtual bool setSoubiSlot(QVector<SoubiSlot*> *slotVector);
    virtual bool addSlotSoubiOfGroupingOf(Data *data);
    virtual bool setVisibleSoubiTableList(QList<Data*> *list);
    virtual QList<Data*>* getVisibleSoubiTableList();
    virtual bool addGeneralSoubiOfGroupingOf(Data *data);
    virtual bool removeSlotSoubiFromWidget(int i);
    virtual bool removeGeneralSoubiFromWidget(int i);

private:
    Ui::SoubiForm *ui;
    QList<Data*> _groupingList;
    Data *_ownGeneral;
    QVector<SoubiSlot*> *_soubiSlot;
    QTableWidget *_visibleSoubiTableWidget;
    QList<Data*> *_visibleSoubiTableList;
    QList<Data*> *_generalSoubiList;

signals:
    void getSlotSoubi(int i, Data *soubi);
    void getGeneralSoubi(int i, Data *soubi);
    void removeSlotSoubi(int);
    void removeGeneralSoubi(int);

public slots:
    void GetSelectedCorona(Data* corona);
    void GetSelectedMeme(Data* meme);
    void GetSelectedBranch(Data* branch);
    void getRemovedCategory(Data* category);
    void partSoubiTableWidget_cellClicked();
    void removeSelectedSlotSoubi(int);
    void removeSelectedGeneralSoubi(int);

private slots:
    void on_removeGeneralSoubiButton_clicked();
    void on_soubiTableWidget_cellClicked(int row, int column);
    void on_generalSoubiTableWidget_cellClicked(int row, int column);
    void on_removeSlotButton_clicked();
    void on_soubiSlotTableWidget_cellClicked(int row, int column);
    void on_groupingTableWidget_clicked(QModelIndex index);
    void on_soubiAddButton_clicked();
};

#endif // SOUBIFORM_H
