#include "soubislot.h"
#include "soubi.h"
#include "grouping.h"
#include <QDebug>
#include <QHeaderView>

QMultiMap<unsigned short, QString>* SoubiSlot::_buiNamesMap = new QMultiMap<unsigned short, QString>();
QVector<QTableWidget*> SoubiSlot::_buiSoubiTableWidgetVector = QVector<QTableWidget*>();
QVector<QList<Data*> > SoubiSlot::_eachBuiSoubiList = QVector<QList<Data*> >();
QMultiMap<unsigned short, unsigned short>* SoubiSlot::_partAndBuiNumbersMap = new QMultiMap<unsigned short, unsigned short>();

SoubiSlot::SoubiSlot(QString partName) :
        _soubi(),
        _partName(partName),
        _partSoubiTableWidget(new QTableWidget(0, 12)),
        _eachPartSoubiList()
{
    //列数指定
    _partSoubiTableWidget->setHorizontalHeaderItem(0, new QTableWidgetItem(QObject::tr("分類"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(1, new QTableWidgetItem(QObject::tr("名称"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(2, new QTableWidgetItem(QObject::tr("購入"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(3, new QTableWidgetItem(QObject::tr("常備"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(4, new QTableWidgetItem(QObject::tr("部位"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(5, new QTableWidgetItem(QObject::tr("必要能力値"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(6, new QTableWidgetItem(QObject::tr("行動値修正"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(7, new QTableWidgetItem(QObject::tr("ダメージ"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(8, new QTableWidgetItem(QObject::tr("HP修正"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(9, new QTableWidgetItem(QObject::tr("射程"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(10, new QTableWidgetItem(QObject::tr("備考"), 0) );
    _partSoubiTableWidget->setHorizontalHeaderItem(11, new QTableWidgetItem(QObject::tr("参照"), 0) );
    _partSoubiTableWidget->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    _partSoubiTableWidget->horizontalHeader()->setStretchLastSection(true);
    _partSoubiTableWidget->verticalHeader()->setVisible(false);
    _partSoubiTableWidget->setSelectionBehavior(QAbstractItemView::SelectRows);
    _partSoubiTableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
    _partSoubiTableWidget->setHorizontalScrollMode(QAbstractItemView::ScrollPerPixel);
    _partSoubiTableWidget->hide();
    QObject::connect(_partSoubiTableWidget, SIGNAL(clicked(QModelIndex)), _partSoubiTableWidget, SLOT(resizeColumnsToContents()));
    _partSoubiTableWidget->verticalHeader()->setVisible(false);
}

SoubiSlot::~SoubiSlot()
{
}

/**
  装備箇所の名前を設定
  */
bool SoubiSlot::setPartName(QString name)
{
    _partName = name;
    return true;
}

/**
  装備箇所の名前を取得
  入力：指標
  出力：装備箇所の名前
  */
QString SoubiSlot::getPartName()
{
    return _partName;
}

/**
  部位の数を返す
  */
unsigned short SoubiSlot::getBuiSize()
{
    return _buiNamesMap->keys().size();
}

/**
  装備スロットに装備を設定
  入力：指標、装備データ
  出力：なし
  */
bool SoubiSlot::setSoubi(Data *soubi)
{
    _soubi = soubi;
    return true;
}

/**
  装備スロットの装備を取得
  入力：指標
  出力：装備データ
  */
Data* SoubiSlot::getSlotSoubi()
{
    return _soubi;
}

/**
  部位名称略称リストに略称を追加
  */
bool SoubiSlot::addBuiName(unsigned short num, QString something)
{
    _buiNamesMap->insert(num, something);
    return true;
}

/**
  各部位の名称の略称を追加
  */
bool SoubiSlot::addBuiName(unsigned short num, QList<QString> something)
{
    for(unsigned short i=0;i<something.size();++i)
    {
        _buiNamesMap->insert(num, something.at(i));
    }
    return true;
}

/**
  指定された番号に対応する部位名称略称の一覧を取得
  */
QVector<QString> SoubiSlot::getBuiNamesVector(unsigned short num)
{
    //return _buiNameVector->value(num);
    return _buiNamesMap->values(num).toVector();
}

/**
  装備箇所と部位を結びつける
  */
bool SoubiSlot::setPartAndBuiNumbersMap(QMultiMap<unsigned short, unsigned short> *map)
{
    _partAndBuiNumbersMap = map;
    return true;
}

/**
  装備箇所と部位を結びつける
  */
bool SoubiSlot::combineBuiNumbersToPartNumber(unsigned short partNumber, unsigned short buiNumber)
{
    _partAndBuiNumbersMap->insert(partNumber, buiNumber);
    return true;
}

/**
  部位ごとの装備のテーブルウィジェットをリストに加える
  */
bool SoubiSlot::addBuiSoubiTableWidget(int i, QTableWidget *qtw)
{
    _buiSoubiTableWidgetVector.replace(i, qtw);
    return true;
}

/**
  部位ごとの装備のテーブルウィジェットのリストを取得
  */
QVector<QTableWidget*> SoubiSlot::getBuiSoubiTableWidget()
{
    return _buiSoubiTableWidgetVector;
}

/**
  data以下の各分類での各部位ごと、装備箇所ごとの装備を持つテーブルウィジェットの作成
  初期化処理
  入力：data(generalを想定)
  出力：なし
  */
/**
  各部位の装備データのリスト
  */
bool SoubiSlot::addEachBuiSoubi(unsigned short i, Data *soubi)
{
    if(i>=_eachBuiSoubiList.size())
    {
        _eachBuiSoubiList.resize(i+1);
    }
    _eachBuiSoubiList[i].append(soubi);
    return true;
}

/**
  各部位の
  */
QList<Data*> SoubiSlot::getEachBuiSoubi(unsigned short i)
{
    if(i<_eachBuiSoubiList.size())
    {
        return _eachBuiSoubiList.at(i);
    }
    else
    {
        return QList<Data*>();
    }
}

bool SoubiSlot::removeEachBuiSoubi(Data *soubi)
{
    for(unsigned short i=0;i<_eachBuiSoubiList.size();++i)
    {
        if(_eachBuiSoubiList.at(i).contains(soubi))
        {
            _eachBuiSoubiList[i].removeOne(soubi);
            return true;
        }
    }
    return false;
}
/**
  装備箇所ごとの装備のテーブルウィジェットをリストに加える
  */
bool SoubiSlot::addPartSoubiTableWidget(QTableWidget *qtw)
{
    _partSoubiTableWidget = qtw;
    return true;
}

/**
  装備箇所ごとの装備のテーブルウィジェットのリストを取得
  */
QTableWidget* SoubiSlot::getPartSoubiTableWidget()
{
    return _partSoubiTableWidget;
}

/**
  各装備箇所の装備データのリスト
  */
bool SoubiSlot::addEachPartSoubi(Data *soubi)
{
    _eachPartSoubiList.append(soubi);
    return true;
}

/**
  各装備箇所の
  */
QList<Data*>* SoubiSlot::getEachPartSoubi()
{
    return &_eachPartSoubiList;
}

/**
  装備箇所の装備リストから装備データを削除
  */
bool SoubiSlot::removeEachPartSoubi(Data *soubi)
{
    _eachPartSoubiList.removeOne(soubi);
    return true;
}

/**
  装備箇所と部位の指標マップを返す
  */
QMultiMap<unsigned short, unsigned short>* SoubiSlot::getPartAndBuiNumbersMap()
{
    return _partAndBuiNumbersMap;
}
