#ifndef SOUBISLOT_H
#define SOUBISLOT_H

#include <QMultiMap>
#include "data.h"

class SoubiSlot
{
public:
    SoubiSlot(QString partName = QString());
    ~SoubiSlot();

    bool setSoubi(Data *soubi = NULL);
    Data* getSlotSoubi();

    bool setPartName(QString name = "");
    QString getPartName();

    //部位
    static unsigned short getBuiSize();
    static bool addBuiName(unsigned short num, QString something);
    static bool addBuiName(unsigned short num, QList<QString> something);
    static QVector<QString> getBuiNamesVector(unsigned short num);

    static bool addBuiSoubiTableWidget(int i, QTableWidget* qtw);
    static QVector<QTableWidget*> getBuiSoubiTableWidget();
    static bool addEachBuiSoubi(unsigned short i, Data *soubi);
    static QList<Data*> getEachBuiSoubi(unsigned short i);
    static bool removeEachBuiSoubi(Data *soubi);

    //装備箇所
    bool addPartSoubiTableWidget(QTableWidget* qtw);
    QTableWidget* getPartSoubiTableWidget();
    bool addEachPartSoubi(Data *soubi);
    QList<Data*> *getEachPartSoubi();
    bool removeEachPartSoubi(Data *soubi);

    //部位と装備箇所の接続
    static bool combineBuiNumbersToPartNumber(unsigned short partNumber, unsigned short buiNumber);
    static bool setPartAndBuiNumbersMap(QMultiMap<unsigned short, unsigned short> *map);
    static QMultiMap<unsigned short, unsigned short>* getPartAndBuiNumbersMap();

private:
    Data *_soubi;

    //部位
    static QMultiMap<unsigned short, QString> *_buiNamesMap;
    static QVector<QTableWidget*>_buiSoubiTableWidgetVector;
    static QVector<QList<Data*> > _eachBuiSoubiList;

    //装備箇所
    QString _partName;
    QTableWidget*_partSoubiTableWidget;
    QList<Data*> _eachPartSoubiList;

    //部位と装備箇所の接続
    static QMultiMap<unsigned short, unsigned short> *_partAndBuiNumbersMap;
};

#endif // SOUBISLOT_H
