#include "tokugi.h"

unsigned short Tokugi::_totalInitialLevel = 0;
unsigned short Tokugi::_totalExperimentalLevel = 0;

Tokugi::Tokugi(QString name,
               Data *parent,
               QVector<QString> property,
               unsigned short initialLevel,
               unsigned short experimentalLevel)
                   :Data(name, parent),
                   _property(property),
                   _initialLevel(initialLevel),
                   _experimentalLevel(experimentalLevel)
{
    _property[0] = name;
}

Tokugi::~Tokugi()
{
}

QString Tokugi::GetName()
{
    return _property.value(0);
}

bool Tokugi::SetName(QString name)
{
    _property[0] = name;
    return true;
}

Tokugi* Tokugi::GetTokugi()
{
    return this;
}

QString Tokugi::GetReference()
{
    return _property.value(1);
}
bool Tokugi::SetReference(QString reference)
{
    _property[1] = reference;
    return true;
}
QString Tokugi::GetType()
{
    return _property.value(2);
}
bool Tokugi::SetType(QString type)
{
    _property[2] = type;
    return true;
}
QString Tokugi::GetCapability()
{
    return _property.value(3);
}
bool Tokugi::SetCapability(QString capability)
{
    _property[3] = capability;
    return true;
}
QString Tokugi::GetTiming()
{
    return _property.value(4);
}
bool Tokugi::SetTiming(QString timing)
{
    _property[4] = timing;
    return true;
}
QString Tokugi::GetCost()
{
    return _property.value(5);
}
bool Tokugi::SetCost(QString cost)
{
    _property[5] = cost;
    return true;
}
QString Tokugi::GetDetail()
{
    return _property.value(6);
}
bool Tokugi::SetDetail(QString detail)
{
    _property[6] = detail;
    return true;
}
bool Tokugi::AddDetail(QString detail)
{
    _property[6].append(detail);
    return true;
}

QVector<QString> Tokugi::GetProperty()
{
    return _property;
}

unsigned short Tokugi::GetTotalInitialLevel()
{
    return _totalInitialLevel;
}

unsigned short Tokugi::GetTotalExperimentalLevel()
{
    return _totalExperimentalLevel;
}

unsigned short Tokugi::GetInitialLevel()
{
    return _initialLevel;
}

bool Tokugi::IncreaseInitialLevel()
{
    _initialLevel ++;
    _totalInitialLevel ++;
    return true;
}
bool Tokugi::DecreaseInitialLevel()
{
    _initialLevel --;
    _totalInitialLevel --;
    return true;
}

unsigned short Tokugi::GetExperimentalLevel()
{
    return _experimentalLevel;
}
bool Tokugi::IncreaseExperimentalLevel()
{
    _experimentalLevel ++;
    _totalExperimentalLevel ++;
    return true;
}
bool Tokugi::DecreaseExperimentalLevel()
{
    _experimentalLevel --;
    _totalExperimentalLevel --;
    return true;
}
