#ifndef TOKUGI_H
#define TOKUGI_H
#include "data.h"

class Tokugi : public Data
{
public:
    Tokugi(QString name = QString(""),
           Data *parent = NULL,
           QVector<QString> property = QVector<QString>(7,NULL),
           unsigned short initialLevel = 0,
           unsigned short experimentalLevel = 0);
    virtual ~Tokugi();

    virtual QString GetName();
    virtual bool SetName(QString name);
    virtual Tokugi* GetTokugi();

    virtual QString GetReference();
    virtual bool SetReference(QString);
    virtual QString GetType();
    virtual bool SetType(QString);
    virtual QString GetCapability();
    virtual bool SetCapability(QString);
    virtual QString GetTiming();
    virtual bool SetTiming(QString);
    virtual QString GetCost();
    virtual bool SetCost(QString);
    virtual QString GetDetail();
    virtual bool SetDetail(QString);
    virtual bool AddDetail(QString);
    virtual QVector<QString> GetProperty();

    virtual unsigned short GetTotalInitialLevel();
    virtual unsigned short GetTotalExperimentalLevel();
    virtual unsigned short GetInitialLevel();
    virtual unsigned short GetExperimentalLevel();
    virtual bool IncreaseInitialLevel();
    virtual bool DecreaseInitialLevel();
    virtual bool IncreaseExperimentalLevel();
    virtual bool DecreaseExperimentalLevel();

private:
    QVector<QString> _property;
    static unsigned short _totalInitialLevel;
    static unsigned short _totalExperimentalLevel;
    unsigned short _initialLevel;
    unsigned short _experimentalLevel;
};

#endif // TOKUGI_H
