#include "tokugidatainterpreter.h"
#include <QMessageBox>
#include <QDebug>
#include <QHeaderView>

TokugiDataInterpreter::TokugiDataInterpreter() :
        _tokugi()
{
}

Data *TokugiDataInterpreter::Interpret(QList<QString> list, Data *parent)
{
    _tokugi = new Tokugi(list.takeFirst(), parent);

    _tokugi->SetReference(list.takeFirst());
    _tokugi->SetType(list.takeFirst());
    _tokugi->SetCapability(list.takeFirst());
    _tokugi->SetTiming(list.takeFirst());
    _tokugi->SetCost(list.takeFirst());

    int baseColumn = -1;
    QTableWidget* ttw = parent->getTokugiTableWidget();
    for(int k=0;ttw->columnCount();++k)
    {
        if( ttw->horizontalHeaderItem(k)->text().contains(QObject::tr("所属")) )
        {
            baseColumn = k;
            break;
        }
    }
    if(baseColumn==-1)
    {
        QMessageBox::warning(NULL, QObject::tr("Warning"), QObject::tr("所属列が見つかりません"), QMessageBox::Ok, QMessageBox::NoButton);
        return NULL;
    }

    ttw->setRowCount(ttw->rowCount()+1);
    int row = ttw->rowCount() -1;
    ttw->setItem(row, baseColumn, new QTableWidgetItem( parent->GetName(), 0) );
    for(int j=0;j<6;j++)
    {
        ttw->setItem(row, j+1, new QTableWidgetItem( _tokugi->GetProperty().at(j), 0 ) );
    }
    if(_tokugi->GetName().contains("◆"))
    {
        parent->addAutGetTokugiList(_tokugi);
    }
    parent->Add(_tokugi);
    return _tokugi;
}

Data *TokugiDataInterpreter::Interpret(QString str, Data *parent)
{
    QRegExp tokugi2("^【([^／]+)／([^／]+)／([^／]+)／([^／]+)／([^／]+)】(.+$)");
    tokugi2.setMinimal(true);
    QRegExp tokugiDetail("[(　)\\s]*([^(　)\\s]*)[(　)\\s]*$");
    tokugiDetail.setMinimal(true);

    if(tokugi2.indexIn(str) > -1)
    {
        _tokugi = new Tokugi(tokugi2.cap(6), parent);

        _tokugi->SetReference(tokugi2.cap(1));
        _tokugi->SetType(tokugi2.cap(2));
        _tokugi->SetCapability(tokugi2.cap(3));
        _tokugi->SetTiming(tokugi2.cap(4));
        _tokugi->SetCost(tokugi2.cap(5));

        parent->Add(_tokugi);

        int baseColumn = -1;
        QTableWidget* ttw = parent->getTokugiTableWidget();
        for(int k=0;ttw->columnCount();++k)
        {
            if( ttw->horizontalHeaderItem(k)->text().contains(QObject::tr("所属")) )
            {
                baseColumn = k;
                break;
            }
        }
        if(baseColumn==-1)
        {
            QMessageBox::warning(NULL, QObject::tr("Warning"), QObject::tr("所属列が見つかりません"), QMessageBox::Ok, QMessageBox::NoButton);
            return NULL;
        }

        int row = ttw->rowCount() +1;
        ttw->setRowCount(row);
        ttw->setItem(row, baseColumn, new QTableWidgetItem( parent->GetName(), 0) );
        for(int j=1;j<=6;++j)
        {
            ttw->setItem(row, j, new QTableWidgetItem( tokugi2.cap(j), 0 ));
        }

        parent->Add(_tokugi);
        {
            parent->addAutGetTokugiList(_tokugi);
        }
        return _tokugi;
    }
    else if(tokugiDetail.indexIn(str) > -1)
    {
        _tokugi->AddDetail(tokugiDetail.cap(1));

        if(_tokugi->GetParent()->getTokugiTableWidget() != NULL)
        {
            QTableWidget *widget = _tokugi->GetParent()->getTokugiTableWidget();
            widget->setItem(widget->rowCount() -1, 7, new QTableWidgetItem(_tokugi->GetDetail() ) );
        }
    }
    else
    {
        return GoNext(str, parent);
    }
    return NULL;
}
