#!/usr/local/bin/ruby

# Examples.rb [port]

$LOAD_PATH.unshift('../../')
require 'webrick'
require 'cgikit'
require 'cgikit/webrick'
require 'cgikit/lang/ja'
require 'lib/application'
require 'lib/session'
require 'lib/directaction'

port = (ARGV.shift || 8080).to_i

app = Examples::Application.new
app.load_all_components('./components')
app.load_configuration('./cgikitconf.rb')
app.resource_store_class = CGIKit::MemoryResourceStore

server = WEBrick::HTTPServer.new({:Port => port})
server.mount('/', WEBrick::CGIKitServlet::ApplicationHandler, app)

trap("INT"){ server.shutdown }
server.start
