require 'cgikit/displaygroup'
require 'book'
require 'dummydata'

module ShowDisplay

  class MainPage < CGIKit::Component

    ASC = 'ASC'
    DESC = 'DESC'

    attr_reader :group, :sort_method_for_title, :sort_method_for_author, \
    :sort_method_for_price

    def init
      restore
      @selections = {}
      @sort_method_for_title = ASC
      @sort_method_for_author = ASC
      @sort_method_for_price = ASC
      @query_mode = false
    end

    def restore
      @group = CGIKit::DisplayGroup.new
      @group.objects = dummydata()
      @group.data_class = Book
      @group.default_values = Book.default_values
      @group.update
    end

    def select_all
      @selections.clear
      @group.displays.each do |obj|
        @selections[obj] = true
      end
    end

    def unselect_all
      @selections.clear
    end

    def edit
      objects = []
      @selections.each do |sel, checked|
        objects << sel if checked
      end
      @selections.clear
      edit = page(EditPage)
      edit.back_page = self
      edit.objects = objects
      edit
    end

    def delete
      @group.objects.delete_if { |obj| @selections[obj] }
      @group.update
    end

    def tr_bgcolor
      if (@item_index % 2) == 0 then
        "#aaaacc"
      else
        "#ddddff"
      end
    end

    def sort_title
      @sort_method_for_title = sort(:title, @sort_method_for_title)
    end

    def sort_author
      @sort_method_for_author = sort(:author, @sort_method_for_author)
    end

    def sort_price
      @sort_method_for_price = sort(:price, @sort_method_for_price)
    end

    def sort( key, method_name )
      method = sort_method(method_name)
      @group.sort_keys.clear
      @group.add_sort_key(key, method)
      @group.update
      reverse_sort_method(method_name)
    end

    def sort_method( value )
      value == ASC ? :> : :<
    end

    def reverse_sort_method( value )
      value == ASC ? DESC : ASC
    end

    def switch_query_mode
      @group.query_mode = !@group.query_mode
      @ignore_case = true
    end

    def filter
      org = @group.query_match[:title]
      unless @group.query_max[:price].empty? then
        @group.query_max[:price] = @group.query_max[:price].to_i
      else
        @group.query_max.delete(:price)
      end
      unless @group.query_min[:price].empty? then
        @group.query_min[:price] = @group.query_min[:price].to_i
      else
        @group.query_min.delete(:price)
      end
      unless @group.query_match[:title].empty? then
        regexp = (@ignore_case ? /#{org}/i : /#{org}/)
        @group.query_match[:title] = regexp
        @group.query_operator[:title] = :=~
      else
        @group.query_match.delete(:title)
        @group.query_operator.delete(:title)
      end
      @group.qualify
      @group.query_match[:title] = org
    end

  end

end
