module CGIKit

  # Classes under Adapter are interface between CGIKit and web servers.
  # 
  # The role of adapter is to provide the consistent interface to 
  # Application. The difference of the relationship between 
  # CGIKit and a web server is aboserbed by the obejct. 
  module Adapter
    
    class CGI
      attr_accessor :headers, :params
      attr_reader :input, :output, :error

      CR  = "\r"
      LF  = "\n"
      EOL = CR + LF
      
      def initialize
        @headers = ENV
        @input   = $stdin
        @output  = $stdout
        @error   = $stderr
        @params = Utilities.query_from_headers(@headers, @input)
      end
      
      def create_request
        Request.new(headers, params)
      end
      
      def create_response
        Response.new(headers)
      end
      
      def run( request, response, &block )
        request ||= create_request
        
        if block_given?
          response = block.call(request)
        end

        print response.header
        print response.to_s
      end
      
    end
    
    class ModRuby < CGI
      
      def initialize
        @input   = $stdin
        @output  = $stdout
        @error   = $stderr
        
        ap_req = Apache.request
        
        @headers = {}
        ap_req.subprocess_env.each {|key,value|
          @headers[key] = value
        }
        
        @params = Utilities.query_from_headers(@headers, @input)
      end
      
      def run( request, response, &block )
        ck_req = CGIKit::Request.new(@headers, @params)

        if block_given?
          ck_res = block.call(ck_req)
        end
        
        # import from cgi.rb
        #
        # This implementation is awkward and slow.
        ap_req = Apache.request  
        table = ap_req.headers_out
        ck_res.header.scan(/([^:]+): (.+)#{EOL}/n){ |name, value|
          case name
          when 'Set-Cookie'
            table.add(name, value)
          when /^status$/ni
            ap_req.status_line = value
            ap_req.status = value.to_i
          when /^content-type$/ni
            ap_req.content_type = value
          when /^content-encoding$/ni
            ap_req.content_encoding = value
          when /^location$/ni
            if ap_req.status == 200
              ap_req.status = 302
            end
            ap_req.headers_out[name] = value
          else
            ap_req.headers_out[name] = value
          end
        }
        
        ap_req.send_http_header
        ap_req.write(ck_res.to_s)
      end
    end
    
    class Template < CGI
      def initialize
        require 'stringio'
        @headers = ENV
        @input   = StringIO.new
        @output  = StringIO.new
        @error   = StringIO.new
        @params  = Hash.new([])
      end
      
      def run( request, response, &block )
        request ||= create_request
        
        if block_given?
          response = block.call(request)
        end
        
        response
      end
    end
    
  end
  
end



