module CGIKit::Ajax

  class Alert < CGIKit::Delegate

    class << self
      include CGIKit

      def support_classes
        [Link, Form, Submit]
      end

    end

    def alert
      CGIKit::Utilities.escape_html("alert(\"#{value(:message)}\")")
    end

    def link_will_generate_tag( tag )
      tag[:onclick] = alert()
      nil
    end

    def form_will_generate_tag( tag, query )
      tag[:onsubmit] = alert()
      nil
    end

    def submit_will_generate_tag( tag )
      tag[:onclick] = alert()
      nil
    end

  end

end
