module CGIKit::Ajax

  class Confirm < CGIKit::Delegate

    class << self
      include CGIKit

      def support_classes
        [Link, Form, Submit]
      end

    end

    def confirm
      CGIKit::Utilities.escape_html("return confirm(\"#{value(:message)}\")")
    end

    def link_will_generate_tag( tag )
      tag[:onclick] = confirm()
      nil
    end

    def form_will_generate_tag( tag, query )
      tag[:onsubmit] = confirm()
      nil
    end

    def submit_will_generate_tag( tag )
      tag[:onclick] = confirm()
      nil
    end

  end

end
