module CGIKit::Ajax

  class LoadScripts < CGIKit::DynamicElement
    include CGIKit::ResourceLoadable

    DEFAULT_FILES = ['prototype.js']

    class << self
      include CGIKit

      def create_api
        api = API.new(:LoadScripts)
        files = Binding.new(:files)
        api << package_binding()
        api << files
        api
      end

    end

    def append_to_response( response, context )
      take_value(:files)
      take_value(:package)

      urls = nil
      if @values[:files] then
        urls = resource_urls(@values[:files], @values[:package], context.request)
      else
        urls = cgikit_resource_urls(DEFAULT_FILES)
      end
      urls.each do |url|
        response.content << script(url)
      end
    end

    def script( path )
      "<script type=\"text/javascript\" src=\"#{path}\"/>\n"
    end

  end

end

