module CGIKit::Ajax

  class ObservedField < TextField
    include CGIKit

    LOAD_IMAGE = 'observer_load.gif'
    COMPLETE_IMAGE = 'observer_complete.gif'

    class << self
      include CGIKit

      # frequency, action, 
      def create_api
        api = CGIKit::API.new(:ObservedField)
        frequency = Binding.new(:frequency)
        update = Binding.new(:update)
        load_label = Binding.new(:load_label)
        load_label.default = 'loading'
        complete_label = Binding.new(:complete_label)
        complete_label.default = 'complete'
        load_image = Binding.new(:load_image)
        load_image.value_set = Binding::RESOURCES
        load_image.default = LOAD_IMAGE
        complete_image = Binding.new(:complete_image)
        complete_image.value_set = Binding::RESOURCES
        complete_image.default = COMPLETE_IMAGE
        api << frequency
        api << update
        api << load_label
        api << complete_label
        api << load_image
        api << complete_image
        api << value_binding(false, true)
        api << enabled_binding()
        api << action_binding()
        api << package_binding('CGIKit')
        api
      end

    end

    def invoke_action( request, context )
      take_value(:action, false)
      result = nil
      if context.action?(request) then
        if @values[:action] then
          result = @root[@values[:action]]
        end
      end
      result
    end

    def append_to_response( response, context )
      id = name_value(context)
      @associations[:id] = Association.new_with_value(id)
      super

      take_value(:frequency)
      take_value(:update)
      take_value(:load_image)
      take_value(:complete_image)
      take_value(:package)

      load_id = "#{id}.load_image"
      complete_id = "#{id}.complete_image"
      if image = image_url(@values[:load_image], context.request) then
        response.content << "<img alt=\"loading image\" id=\"#{load_id}\" src=\"#{image}\" style=\"display:none;\"/>"
      end
      if image = image_url(@values[:complete_image], context.request) then
        response.content << "<img alt=\"complete image\" id=\"#{complete_id}\" src=\"#{image}\" style=\"display:none;\"/>"
      end

      response.content << <<EOS
<script type="text/javascript">
new Form.Element.Observer('#{id}', #{@values[:frequency]},
                          function(element, value) {
  new Ajax.Updater('#{@values[:update]}', '#{context.ajax_component_action_url}', {
    asynchronous:true, evalScripts:true,
    onComplete:function(request) { Toggle.display('#{load_id}') },
    onLoading:function(request) { Toggle.display('#{complete_id}') },
    parameters:value })})
</script>
EOS
    end

    def image_url( name, request )
      @application.resource_manager.url(name,
                                        @values[:package],
                                        request.languages,
                                        request)
    end

  end
end
