module CGIKit::Ajax

  class AjaxComponentRequestHandler < CGIKit::RequestHandler
    include CGIKit

    def self.request_handler_key
      'ajaxc'
    end

    def invoke_action( element, request, context )
      result = nil
      transaction(element, context) do
        result = element.invoke_action(request, context)
      end
      result
    end

    def handle_request( request )
      super

      reset_form_values(request)
      context = @application.create_context(request)

      @application.synchronize do
        transaction(context.component, context) do
          @application.take_values_from_request(request, context)
        end

        result = nil
        context.delete_all
        transaction(context.component, context) do
          result = @application.invoke_action(request, context)
        end

        if Response === result then
          context.response = result
        elsif result.nil? or Array === result or Hash === result then
          context.response.content = XMLSerializer.serialize(result)
        elsif ::String === result then
          context.response.content = result
        else
          if (Component === result) and (context.component != result) then
            result.awake_from_restoration(context)
            context.component = result
          else
            result = context.component.root
          end
          context.delete_all
          transaction(result, context) do
            @application.append_to_response(context.response, context)
          end
          context.response.component = result
        end
      end

      @application.save_session(context)
      context.response.headers['Content-Type'] = 'text/xml'
      context.response
    end

    def reset_form_values( request )
      request.form_values.each_key do |key|
        if key != '_' then
          request.form_values[request.context_id] = [key]
          return
        end
      end
    end

    def url( context, path = nil, query = {},
             is_secure = false, port = nil, sid = true )
      str = application_url(context.request, is_secure, port)
      str << "/#{self.class.request_handler_key}"
      str << "/#{context.session.session_id}"
      str << "/#{context.context_id}"
      str << "/#{path}" if path
      qstr = query_string(query)
      unless qstr.empty? then
        str << "?#{qstr}"
      end
      str
    end

  end


  class AjaxRequestHandler < CGIKit::ActionRequestHandler
    include CGIKit

    def self.request_handler_key
      'ajaxd'
    end

    def default_action_class
      @application.ajax_action_class || AjaxAction
    end

    def handle_request( request )
      super
      action, name = action_and_action_name(request)

      result = nil
      @application.synchronize do
        result = action.perform_action(name)
        if result.respond_to?(:generate_response) then
          response = result.generate_response
          if Component === result then
            response.component = result
            if result.context.has_session? then
              @application.save_session(result.context)
            end
          end
        else
          response = Response.new
          if result.nil? or Array === result or Hash === result then
            response.content = XMLSerializer.serialize(result)
          elsif ::String === result then
            response.content = result
          else
            raise ActionResultError, \
            "Ajax action must return an object has generate_response(), " +
              "not nil, String, Array or Hash. - #{action.class}##{action_name}"
          end
        end
      end

      response.headers['Content-Type'] = 'text/xml'
      response
    end

  end

end


module CGIKit

  class Context

    def ajax_component_action_url( query = {}, is_secure = false )
      complete_url(Ajax::AjaxComponentRequestHandler.request_handler_key,
                   nil, query, is_secure)
    end

    def ajax_action_url( action_class = nil, action_name = 'default',
                         query = {}, sid = true )
      action_class ||= @application.ajax_action_class || CGIKit::Ajax::AjaxAction
      handler = @application.request_handler(Ajax::AjaxRequestHandler.request_handler_key)
      handler.action_url(self, action_class, action_name, query, sid)
    end

  end


  class Application

    attr_accessor :ajax_action_class
    attr_writer :xmlhttp_var

    def xmlhttp_var
      @xmlhttp_var ||= 'xmlhttp'
    end

  end

end

CGIKit::Ajax::AjaxComponentRequestHandler.register
CGIKit::Ajax::AjaxRequestHandler.register
