module CGIKit

  class Delegate

    module CheckboxDelegate

      def checkbox_will_generate_tag( tag ); end

    end

  end


  class Checkbox < DynamicElement

    DELETE_KEYS = [:type]
    DEFAULT_VALUE = '1'

    class << self

      def create_api
        api = API.new(:Checkbox)
        api << name_binding()
        api << checked_binding()
        api << selection_binding()
        api << value_binding(false, false)
        api << enabled_binding()
        api << required_validation([:checked, :value])
        api << universal_validation(:value, :selection)
        api
      end

      def keys_to_delete_from_associations
        DELETE_KEYS
      end

    end

    def begin_context( context )
      take_value(:name)
      context.increment(@values[:name])
    end

    def take_values_from_request( request, context )
      take_value(:value)
      take_value(:selection)
      take_bool(:checked)

      if value = value_from_request(request, context) then
        if declared?(:checked) then
          set_value(:checked, true)
        else
          set_value(:selection, @values[:value])
        end
      elsif context.current_form?(request) then
        if declared?(:checked) then
          set_value(:checked, false)
        else
          set_value(:selection, nil)
        end
      end
    end

    def append_to_response( response, context )
      take_bool(:enabled)
      take_value(:value)
      take_value(:selection)
      take_bool(:checked)
      attrs = { :name => name_value(context), :disabled => !@values[:enabled],
        :value => @values[:value] }
      attrs.update(optional_attributes())

      tag = HTMLTag.checkbox(attrs, other_attribute())
      if declared?(:checked) then
        attrs[:checked] = @values[:checked]
      else
        attrs[:value] = @values[:value]
        attrs[:checked] = \
          (@values[:selection] and (@values[:value] == @values[:selection]))
      end
      ask(:checkbox_will_generate_tag) do |d|
        tag = d.checkbox_will_generate_tag(tag) || tag
      end
      if tag[:value] then
        tag[:value] = escaped_string(tag[:value])
      else
        tag[:value] ||= DEFAULT_VALUE
      end
      response.content << tag.empty_tag
    end
  end

end
