module CGIKit

  class Delegate

    module ConditionalDelegate

      def conditional_will_display; end
      def conditional_will_hide; end

    end

  end


  class Conditional < DynamicElement

    class << self
      def create_api
        api = API.new(:Conditional)
        condition = Binding.new(:condition)
        condition.required = true
        condition.value_set = Binding::BOOLEAN
        negate = Binding.new(:negate)
        negate.value_set = Binding::BOOLEAN
        negate.default = false
        api << condition
        api << negate
        api
      end
    end

    def begin_context( context )
      context.increment
      context.append_zero
    end

    def end_context( context )
      context.delete
    end

    def append_to_response( response, context )
      take_value(:condition)
      take_value(:negate)

      if (((not @values[:negate]) and @values[:condition]) or \
          ((not @values[:condition]) and @values[:negate])) then
        ask(:conditional_will_display, context) do |d|
          d.conditional_will_display
        end
        @node.append_to_response(response, context)
      else
        ask(:conditional_will_hide, context) do |d|
          d.conditional_will_hide
        end
      end
    end

  end

end
