module CGIKit

class Content < DynamicElement

  def take_values_from_request( request, context )
    preserve_context_id(context) do
      @root.node.take_values_from_request(request, context)
    end
  end

  def invoke_action( request, context )
    result = nil
    preserve_context_id(context) do
      result = @root.node.invoke_action(request, context)
    end
    result
  end

  def append_to_response( response, context )
    preserve_context_id(context) do
      @root.node.append_to_response(response, context)
    end
  end

  def preserve_context_id( context, &block )
    before = context.context_id
    context.context_id = @root.parent_context_id
    block.call
    context.context_id = before
  end

end

end
