module CGIKit

  class Delegate

    module FormDelegete

      def form_should_invoke_action; end
      def form_take_values( values ); end
      def form_will_generate_tag( tag, query ); end

    end

  end


  class Form < DynamicElement

    MULTIPART_FORM_DATA = "multipart/form-data"

    class << self
      def create_api
        api = API.new(:Form)
        method = Binding.new(:method)
        method.default = 'POST'
        enctype = Binding.new(:enctype)
        query = Binding.new(:query)
        upload = Binding.new(:upload)
        upload.value_set = Binding::BOOLEAN
        upload.default = false
        action = Binding.new(:action)

        api << method
        api << enctype
        api << href_binding()
        api << query
        api << upload
        api << action
        api << name_binding()
        api << secure_binding()
        api << session_id_binding()
        api << existential_validation(:href, :action)
        api << existential_validation(:enctype, :upload)
        set_direct_action(api)
        api
      end
    end

    attr_accessor :has_action_in_container

    def init
      @has_action_in_container = false
    end

    def notify_existing_action_in_container
      @has_action_in_container = true
    end

    def begin_context( context )
      take_value(:name)
      context.increment
      context.append_zero
      context.in_form = true
      unless direct_action? then
        context.session.save_page(@root)
        context.component_id = context.session.component_id(@root)
      end
    end

    def end_context( context )
      context.delete
      context.in_form = false
    end

    def take_values_from_request( request, context )
      ask(:form_take_values) do |d|
        if values = d.form_take_values(request.form_values) then
          request.form_values = values
        end
      end
      @node.take_values_from_request(request, context)
    end

    def invoke_action( request, context )
      ask(:form_should_invoke_action) do |d|
        return unless d.form_should_invoke_action
      end

      take_value(:action, false)
      before = context.context_id
      result = @node.invoke_action(request, context)
      if !@has_action_in_container and \
        context.action?(request, before) and @values[:action] then
        result = @root[@values[:action]]
      end
      result
    end

    def append_to_response( response, context )
      take_value(:method)
      take_value(:enctype)
      take_value(:href)
      take_value(:query)
      take_bool(:secure)
      take_bool(:upload)
      take_value(:session_id)
      take_value(:direct_action, false)
      take_value(:action_class)

      attrs = {}
      unless (@values[:method].downcase == 'post') or \
        (@values[:method].downcase == 'get') then
        @values[:method] = 'post'
      end
      attrs[:method] = @values[:method]
      attrs[:enctype] = @values[:upload] ? MULTIPART_FORM_DATA : @values[:enctype]

      attrs[:name] = name_value(context)
      if @values[:href] then
        url = @values[:href]
      elsif direct_action? then
        url = context.direct_action_url(@values[:action_class],
                                        @values[:direct_action],
                                        {},
                                        @values[:session_id])
      else
        secure = has_binding?(:secure) ? @values[:secure] : context.request.https?
        url = context.component_action_url({}, secure)
      end
      attrs[:action] = url

      attrs.update(optional_attributes())
      other_s = other_attribute()

      tag = HTMLTag.form(attrs, other_s)
      query = @values[:query] || {}
      ask(:form_will_generate_tag) do |d|
        tag = d.form_will_generate_tag(tag, query) || tag
      end

      response.content << tag.open_tag
      response.content << "\n"
      response.content << hidden_fields(query)
      @node.append_to_response(response, context)
      response.content << tag.close_tag
    end


    def hidden_fields( query )
      fields = ''
      query.each do | key, value |
        value = Utilities.escape_html(value.to_s)
        fields << \
        "<input type=\"hidden\" name=\"#{key}\" value=\"#{value}\"/>\n"
      end
      fields
    end
  end

end
