module CGIKit

  class ImageLink < Link
    include ResourceLoadable
    include Link::Utilities

    class << self
      def create_api
        api = API.new(:ImageLink)
        data = Binding.new(:data)
        key = Binding.new(:key)
        api << data
        api << key
        api << file_binding()
        api << package_binding()
        api << mime_binding()
        api << src_binding()
        api << action_binding()
        api << enabled_binding()
        api << href_binding()
        api << page_binding()
        api << secure_binding()
        api << query_binding()
        api << frag_binding()
        api << session_id_binding()
        set_direct_action(api)
        api << required_validation([:action, :href, :page], [], \
                                   [:direct_action, :action_class])
        api
      end
    end

    def begin_context( context )
      context.increment
    end

    def end_context( context ); end

    def append_to_response( response, context )
      take_value(:file)
      take_value(:package)
      take_value(:data)
      take_value(:key)
      take_value(:mime)
      take_value(:src)
      take_bool(:enabled)
      aattrs = { :name => name_value(context), :disabled => !@values[:enabled] }
      aattrs.update(optional_attributes(:a))
      imgattrs = { :src => @values[:src] }
      imgattrs.update(optional_attributes(:img))
      unless imgattrs[:src] then
        imgattrs[:src] = caching_url(@values[:file], @values[:package],
                                     @values[:data], @values[:key],
                                     @values[:mime], context.request)
      end
      ask(:image_generate_url) do |d|
        imgattrs[:src] = d.image_generate_url(imgattrs[:src])
      end
      imgtag = HTMLTag.img(imgattrs, other_attribute(:img))
      ask(:image_will_generate_tag) do |d|
        imgtag = d.image_will_generate_tag(imgtag) || imgtag
      end
      atag = HTMLTag.a(aattrs, other_attribute(:a), imgtag.empty_tag)
      set_href(atag, context)
      response.content << atag.container_tag
    end

  end

end
