module CGIKit

  class Outline < DynamicElement

    class << self
      def create_api
        api = API.new(:Outline)
        default = Binding.new(:default)
        default.value_set = Binding::BOOLEAN
        default.required = false
        default.default = false
        expanded = Binding.new(:expanded)
        expanded.required = true
        expanded.value_set = Binding::BOOLEAN
        open_label = Binding.new(:open_label)
        open_label.default = 'open'
        close_label = Binding.new(:close_label)
        close_label.default = 'close'
        open_image = Binding.new(:open_image)
        open_image.value_set = Binding::RESOURCES
        open_image.default = 'outline_open_arrow.png'
        close_image = Binding.new(:close_image)
        close_image.value_set = Binding::RESOURCES
        close_image.default = 'outline_close_arrow.png'
        label_tag = Binding.new(:label_tag)
        label_tag.default = 'div'
        label_class = Binding.new(:label_class)
        expand_tag = Binding.new(:expand_tag)
        expand_tag.default = 'div'
        expand_class = Binding.new(:expand_class)
        api << default
        api << expanded
        api << open_label
        api << close_label
        api << open_image
        api << close_image
        api << label_tag
        api << label_class
        api << expand_tag
        api << expand_class
        api << package_binding('CGIKit')
        api << action_binding()
        api
      end
    end

    def begin_context( context )
      context.increment
      context.append_zero
    end

    def end_context( context )
      context.delete
    end

    def invoke_action( request, context )
      take_value(:action, false)
      take_bool(:expanded)

      result = nil
      if context.action?(request) then
        set_value(:expanded, !@values[:expanded])
        if @values[:action] then
          result = @root[@values[:action]]
        else
          result = @node.invoke_action(request, context)
        end
      end
      result
    end

    def append_to_response( response, context )
      take_bool(:default)
      take_bool(:expanded)
      take_value(:open_label)
      take_value(:close_label)
      take_value(:open_image)
      take_value(:close_image)
      take_value(:label_tag)
      take_value(:label_class)
      take_value(:expand_tag)
      take_value(:expand_class)
      take_value(:package)

      label_open_tag = label_close_tag = nil
      label_close_tag = "</#{@values[:label_tag]}>"
      expand_close_tag = "</#{@values[:expand_tag]}>"
      if klass = @values[:label_class] then
        label_open_tag = "<#{@values[:label_tag]} class=\"#{klass}\">"
      else
        label_open_tag = "<#{@values[:label_tag]}>"
      end
      if klass = @values[:expand_class] then
        expand_open_tag = "<#{@values[:expand_tag]} class=\"#{klass}\">"
      else
        expand_open_tag = "<#{@values[:expand_tag]}>"
      end

      expanded = @values[:expanded] || @values[:default]
      context.session
      url = context.component_action_url
      if expanded then
        response.content << label_open_tag
        if image = image_url(@values[:open_image], context.request) then
          response.content << "<a href=\"#{url}\"><image src=\"#{image}\"></a> "
        end
        response.content << "<a href=\"#{url}\">#{@values[:open_label]}</a>"
        response.content << label_close_tag
        response.content << expand_open_tag
        @node.append_to_response(response, context)
        response.content << expand_close_tag
      else
        response.content << label_open_tag
        if image = image_url(@values[:close_image], context.request) then
          response.content << "<a href=\"#{url}\"><image src=\"#{image}\"></a> "
        end
        response.content << "<a href=\"#{url}\">#{@values[:close_label]}</a>"
        response.content << label_close_tag
      end
    end

    def image_url( name, request )
      @application.resource_manager.url(name,
                                        @values[:package],
                                        request.languages,
                                        request)
    end

  end

end
