module CGIKit

  class Refresh < Link

    class << self
      def create_api
        api = API.new(:Refresh)
        api << Binding.new(:seconds)
        api << Binding.new(:url)
        api << action_binding()
        api << page_binding()
        api << secure_binding()
        api << query_binding()
        api << frag_binding()
        api << session_id_binding()
        set_direct_action(api)
        api << required_validation([:action, :url, :page], [], \
                                   [:direct_action, :action_class])
        api
      end
    end

    def invoke_action( request, context )
      take_value(:page)
      take_value(:action, false)
      result = nil
      if context.action?(request) then
        if @values[:page] then
          result = @application.page(@values[:page], context)
        else
          result = @root[@values[:action]]
        end
      end
      result
    end

    def append_to_response( response, context )
      take_value(:seconds)
      take_value(:url)

      unless url = @values[:url] then
        url = action_url(context)
      end
      html =  "<meta http-equiv=\"refresh\" "
      html << "content=\"#{@values[:seconds]}; URL=#{url}\""
      html << other()
      html << ' />'
      response.content << html
    end

  end

end
