module CGIKit

  class Delegate

    module RepetitionDelegate

      def repetition_should_repeat( list ); end
      def repetition_should_each_repeat( list ); end
      def repetition_will_each_repeat( item, index ); end
      def repetition_did_each_repeat( item, index ); end

    end

  end


  module ElementEnumerable

    def each( context )
      ask(:repetition_should_repeat, context) do |d|
        unless d = d.repetition_should_repeat(@values[:list]) then
          return
        end
      end
      flag = true
      each_node(context) do |node|
        flag = true
        ask(:repetition_should_each_repeat, context) do |d|
          flag = d.repetition_should_each_repeat(@values[:list])
        end
        yield node if flag
        increment_context_for_next_loop(context)
      end
    end

    def each_node( context )
      if list = @values[:list] then
        if Hash === list then
          list.each_with_index do |item, index|
            set_value(:key, item[0])
            set_value(:item, item[1])
            set_value(:index, index) if @values[:index]
            @node.reset
            delegate_phase(context, item, index) do
              yield @node
            end
          end
        else
          index = 0
          list.each do |item|
            set_value(:item, item)
            set_value(:index, index) if @values[:index]
            @node.reset
            delegate_phase(context, item, index) do
              yield @node
            end
            index += 1
          end
        end
      elsif @values[:count] then
        @values[:count].times do |index|
          set_value(:index, index) if @values[:index]
          @node.reset
          delegate_phase(context, nil, index) do
            yield @node
          end
        end
      end
    end

    def increment_context_for_next_loop( context )
      context.delete
      context.increment
      context.append_zero
    end

    def delegate_phase( context, item, index, &block )
      ask(:repetition_will_each_repeat, context) do |d|
        d.repetition_will_each_repeat(item, index)
      end
      block.call
      ask(:repetition_did_each_repeat, context) do |d|
        d.repetition_did_each_repeat(item, index)
      end
    end
  end


  class Repetition < DynamicElement
    include ElementEnumerable

    class << self
      def create_api
        api = API.new(:Repetition)
        index = Binding.new(:index)
        count = Binding.new(:count)
        key = Binding.new(:key)
        key.settable = true
        api << list_binding(false)
        api << item_binding()
        api << index
        api << count
        api << key
        api << required_validation([:count, :list])
        api
      end
    end

    def begin_context( context )
      context.increment
      context.append_zero
    end

    def end_context( context )
      context.delete
    end

    def take_values_from_request( request, context )
      take_value(:index, false)
      take_value(:count)
      take_value(:list)

      each(context) do |node|
        node.take_values_from_request(request, context)
      end
    end

    def invoke_action( request, context )
      result = nil
      each(context) do |node|
        if node_result = node.invoke_action(request, context) then
          result = node_result
        end
      end
      result
    end

    def append_to_response( response, context )
      take_value(:list)
      take_value(:index, false)
      take_value(:count)

      each(context) do |node|
        node.append_to_response(response, context)
      end
    end

  end

end
