module CGIKit

  class Delegate

    module StringDelegate

      def string_will_generate_content( value ); end

    end

  end


  class String < DynamicElement

    class << self
      def create_api
        api = API.new(:String)
        empty = Binding.new(:empty)
        br = Binding.new(:br)
        br.value_set = Binding::BOOLEAN
        api << value_binding()
        api << escape_binding()
        api << empty
        api << br
        api
      end
    end

    def append_to_response( response, context )
      take_value(:value)
      take_value(:empty)
      take_bool(:escape)
      take_bool(:br)

      ask(:string_will_generate_content, context) do |d|
        alt = d.string_will_generate_content(@values[:value])
        @values[:value] = alt if alt
      end

      str = ''
      if @values[:value] then
        str = @values[:value].to_s
      elsif @values[:empty] then
        str = @values[:empty].to_s
      end
      str = escaped_string(str, @values[:escape])
      if @values[:br] then
        str.gsub!(/(\r\n|\r|\n)/, "<br />")
      end
      response.content << str
    end
  end

end
