module CGIKit

  class Delegate

    module SubmitDelegate

      def submit_should_invoke_action; end
      def submit_will_generate_tag( tag ); end

    end

  end


  class Submit < DynamicElement
    class << self
      def create_api
        api = API.new(:Sumbit)
        action = Binding.new(:action)
        value = Binding.new(:value)
        value.default = 'Submit'
        api << action
        api << value
        api << enabled_binding()
        api << name_binding()
        set_direct_action(api)
        api << any_validation([:action], [], [:direct_action, :action_class])
        api
      end

      def keys_to_delete_from_associations
        [:type]
      end
    end

    def begin_context( context )
      take_value(:name)
      context.increment(@values[:name])
    end

    def invoke_action( request, context )
      ask(:submit_should_invoke_action) do |d|
        return unless d.submit_should_invoke_action
      end

      take_value(:action, false)
      take_value(:direct_action, false)
      take_value(:action_class)

      result = nil
      if value_from_request(request, context) then
        if @values[:action] then
          result = @root[@values[:action]]
          notify_existing_action_to_form
        elsif @values[:direct_action] or @values[:action_class] then
          result = perform_direct_action(request, @values[:action_class],
                                         @values[:direct_action])
          notify_existing_action_to_form
        end
      end
      result
    end

    def notify_existing_action_to_form
      ancestor = @parent
      while ancestor do
        if Form === ancestor then
          ancestor.notify_existing_action_in_container
          break
        end
        ancestor = ancestor.parent
      end
    end

    def perform_direct_action( request, klass, action = DirectAction::DEFAULT_ACTION )
      unless klass then
        klass = @application.direct_action_class
      end
      direct_action = klass.new(@application, request)
      direct_action.perform_action(action)
    end

    def append_to_response( response, context )
      take_value(:value)
      take_bool(:enabled)
      attrs = {}
      if @values[:value] then
        @values[:value] = escaped_string(@values[:value])
      end

      attrs[:type] = 'submit'
      attrs[:name] = name_value(context)
      attrs[:value] = @values[:value]
      attrs[:disabled] = !@values[:enabled]
      attrs.update(optional_attributes())
      other_s = other_attribute()

      tag = HTMLTag.submit(attrs, other_s)
      ask(:submit_will_generate_tag) do |d|
        tag = d.submit_will_generate_tag(tag) || tag
      end
      response.content << tag.empty_tag
    end

  end

end
