module CGIKit

  class Delegate

    module TextDelegate

      def text_set_value( value ); end
      def text_validate_value( value ); end
      def text_will_generate_tag( tag ); end

    end

  end


  class Text < DynamicElement

    class << self
      def create_api
        api = API.new(:Text)
        api << name_binding()
        api << value_binding(true, true)
        api << enabled_binding()
        set_validation(api)
        api
      end
    end

    def begin_context( context )
      take_value(:name)
      context.increment(@values[:name])
    end

    def take_values_from_request( request, context )
      if value = value_from_request(request, context) then
        ask(:text_validate_value) do |d|
          value = nil unless d.text_validate_value(value)
        end
        ask(:text_set_value) do |d|
          value = d.text_set_value(value)
        end
        set_value(:value, value)
        validate(:value)
      end
    end

    def append_to_response( response, context )
      take_value(:value)
      take_bool(:enabled)
      attrs = { :name => name_value(context),
        :disabled => !@values[:enabled] }
      attrs.update(optional_attributes())

      tag = HTMLTag.textarea(attrs, other_attribute(), @values[:value])
      ask(:text_will_generate_tag) do |d|
        tag = d.text_will_generate_tag(tag) || tag
      end
      if tag.content then
        tag.content = escaped_string(tag.content)
      end
      response.content << tag.container_tag
    end
  end

end
