module CGIKit

# KeyValueCoding provides methods to access object graph.
# The methods try accessing instance variables by using accessor method.
# If it is failure, its try accessing directly.
module KeyValueCoding

  # The method returns "true", the direct access is success. Or failure.
  # Default value is true.
  attr_accessor :access_attributes
  alias access_attributes? access_attributes

  @access_attributes = true

  # Retrieves value for the key.
  def value_for_key( __key )
    # escape sharing local variable scope of instance_eval by __key.
    __key = __key.to_s.gsub(/\A\^(\w+)/) { "binding_value(:#{$1})" }
    begin
      instance_eval(__key.to_s.untaint)
    rescue Exception => e
      if /\A[a-zA-Z0-9_]+\Z/ === __key.to_s then
        raise e, "#{e.message} - #{self.class}##{__key}"
      else
        raise e, "#{e.message} - \"#{__key}\" for #{self.class}"
      end
    end
  end

  def stored_value_for_key( key )
    instance_variable_get("@#{key}")
  end

  # Takes value for the key.
  def take_value_for_key( __key, __value )
    writer = "self.#{__key.to_s}=__value"
    instance_eval(writer.untaint)
  end

  def take_stored_value_for_key( key, value )
    instance_variable_set("@#{key}", value)
  end

  alias value_for_keypath value_for_key
  alias take_value_for_keypath take_value_for_key

  # used only accessing instance variables
  def method_missing( name, *args )
    if access_attributes? then
      if args.empty? then
        return stored_value_for_key(name.to_s)
      elsif (name.to_s =~ /([^=]+)=$/) and (args.size == 1) then
        return take_stored_value_for_key($1, args[0])
      end
    end
    super
  end

end

end
