module CGIKit  
  class RubyVersionError < CGIKitError; end  
end

if RUBY_VERSION <= '1.8.2'
  raise CGIKit::RubyVersionError, "This patch does work at Ruby-1.8.3 or later. If you don't want to use this patch, please assign true to CGIKit::Application.precede_iconv."
end

module REXML
  
  module Encoding
  
    def encoding=( enc )
      old_verbosity = $VERBOSE
      begin
        $VERBOSE = false
        return if defined? @encoding and enc == @encoding
        if enc and enc != UTF_8
          @encoding = enc.upcase
          begin
            raise ArgumentError, "Bad encoding name #@encoding" unless @encoding =~ /^[\w-]+$/
            @encoding.untaint 
            enc_file = File.join( "rexml", "encodings", "#@encoding.rb" )
            require enc_file
            Encoding.apply(self, @encoding)
          rescue LoadError, Exception => err
            begin
              require 'rexml/encodings/ICONV.rb'
              Encoding.apply(self, "ICONV")
            rescue LoadError
              puts $!.message
              raise ArgumentError, "No decoder found for encoding #@encoding.  Please install iconv."
            end
          end
        else
          @encoding = UTF_8
          require 'rexml/encodings/UTF-8.rb'
          Encoding.apply(self, @encoding)
        end
      ensure
        $VERBOSE = old_verbosity
      end
    end  # end of method
    
  end
end
