require 'aop/aop'
require 'logger'

module CGIKit
  
  class SimpleProfilerAspect < Aspect
    
    include Aspect::Context
    
    advice :profile
    
    def self.init_profiler(out = $stderr)
      @logger = ::Logger.new(out)
    end
    
    def self.logger
      @logger
    end
    
    def profile(*args)
      s = Time.now.to_s
      s << ' '
      s << current_context(args[0])
      
      old = Time.now.to_f 
      a = yield
      diff = Time.now.to_f - old
      s << diff.to_s
      
      logger.debug(s)
      a
    end
     
    def logger
      if target.respond_to?(:application)
        target.application.logger 
      else
        SimpleProfilerAspect.logger
      end
    end
    
    self.init_profiler
  end
  
end

if $0 == __FILE__
  require 'csv'
  
  s = <<-EOF
  1,2,3,4,5,6,7
  a,b,c,d,e,f,g
  !,$,%,&,(,),=
  
  EOF
  
  class CSV
    class StringReader
      include_aspect CGIKit::SimpleProfilerAspect, {:profile => /^each$/}
    end
  end
  
  c = CSV::StringReader.new(s * 1000) #(ARGF.read * 100)
  c.each do |i|
    i.inspect
  end
end
