require 'fileutils'
require 'cgikit/package'

module CGIKit; end

module CGIKit::Project

  class PackageGenerator

    attr_accessor :path, :name

    def initialize( path )
      @path = path
      @name = File.basename(path)
    end

    def write
      begin
        FileUtils.makedirs(@path)
        CGIKit::Package.all_resource_paths.each do |path|
          Dir.mkdir(File.join(@path, path))
        end
      rescue Exception => e
        FileUtils.rm_rf(@path)
        raise e
      end
    end

  end

end

