module CGIKit

class Request < Message

  attr_accessor :form_values, :session_id, :context_id, \
  :request_handler_key, :request_handler_path

  class << self
    # Parse query string and return a hash of parameters.
    def parse_query_string( query )
      params = Hash.new([])
      query.split(/[&;]/n).each do |pairs|
        key, value = pairs.split('=',2).collect{|v| Utilities.unescape_url(v) }
        if params.has_key?(key)
          params[key].push(value)
        else
          params[key] = [value]
        end
      end
      params
    end
  end

  def initialize( headers = nil, form_values = nil )
    super headers
    @cookies     = Cookie.parse_raw_cookie(@headers['HTTP_COOKIE'])
    @form_values = Hash.new([])
    @form_values.update(form_values) if form_values
    @request_handler_path = @headers['PATH_INFO']
    @parsed_action = false
  end

  def form_value( key )
    if @form_values.key?(key)
      @form_values[key].first
    else
      ''
    end
  end
  alias [] form_value

  def cookie( key )
    @cookies.each { | cookie |
      if cookie.name == key
        return cookie
      end
    }
    nil
  end

  def cookie_value( key )
    @cookies.each { | cookie |
      if cookie.name == key
        return cookie.value
      end
    }
    nil
  end

  def cookie_values( key = nil )
    if key then
      _cookie_values_for_key( @cookies, key )
    else
      _cookie_values @cookies
    end
  end

  private

  def _cookie_values( cookies )
    values = {}
    cookies.each do |cookie|
      values[cookie.name] = cookie.value
    end
    values
  end

  def _cookie_values_for_key( cookies, key )
    values = []
    cookies.each do |cookie|
      if cookie.name == key then
        values << cookie.value
      end
    end
    values
  end

  public

  def languages
    unless @languages then
      @languages = []
      if accept_language then
        @languages = accept_language.split(',').collect { |entry|
          lang, quality = entry.split(';')
          lang.strip!
          lang = lang.split('-')[0]
          if /^q=(.+)/ =~ quality
            quality = $1.to_f
          else
            quality = 1.0
          end
          [lang, quality]
        }.sort { |a, b| b[1] <=> a[1] }.collect { |i| i[0] }
      end
    end
    @languages
  end

  def action_class
    _parse_action_class_and_name() unless @parsed_action
    @action_class
  end

  def action_name
    _parse_action_class_and_name() unless @parsed_action
    @action_name
  end

  private

  def _parse_action_class_and_name
    klass = nil
    action_name = nil
    if path = @request_handler_path then
      path = path.dup
      path.gsub!(/\A\//, '')
      path.gsub!(/\?(.*)/, '')
      key, class_name, action_name = path.split('/')
      begin
        klass = Object
        class_name.split('::').each do |name|
          klass = klass.const_get(name)
        end
      rescue Exception => e
        klass = nil
        unless action_name then
          action_name = class_name
        end
      end
    end
    if klass and !(klass <= Action) then
      klass = default
      action_name = nil
    end
    @parsed_action = true
    @action_class = klass
    @action_name = action_name
  end

  public

  def https?
    /\Ahttps/ === self.referer or /on/i === @headers['HTTPS']
  end


  #
  # HTTP request headers
  #

  def accept;            @headers['HTTP_ACCEPT']          end
  def accept_charset;    @headers['HTTP_ACCEPT_CHARSET']  end
  def accept_language;   @headers['HTTP_ACCEPT_LANGUAGE'] end
  def auth_type;         @headers['AUTH_TYPE']            end
  def content_length;    @headers['CONTENT_LENGTH']       end
  def content_type;      @headers['CONTENT_TYPE']         end
  def from;              @headers['HTTP_FROM']            end
  def gateway_interface; @headers['GATEWAY_INTERFACE']    end
  def path_info;         @headers['PATH_INFO']            end
  def path_translated;   @headers['PATH_TRANSLATED']      end
  def query_string;      @headers['QUERY_STRING']         end
  def raw_cookie;        @headers['HTTP_COOKIE']          end
  def referer;           @headers['HTTP_REFERER']         end
  def remote_addr;       @headers['REMOTE_ADDR']          end
  def remote_host;       @headers['HTTP_HOST']            end
  def remote_ident;      @headers['REMOTE_IDENT']         end
  def remote_user;       @headers['REMOTE_USER']          end
  def request_method;    @headers['REQUEST_METHOD']       end
  def script_name;       @headers['SCRIPT_NAME']          end
  def server_name;       @headers['SERVER_NAME']          end
  def server_port;       @headers['SERVER_PORT']          end
  def server_protocol;   @headers['SERVER_PROTOCOL']      end
  def server_software;   @headers['SERVER_SOFTWARE']      end
  def uri;               @headers['REQUEST_URI']          end
  def user_agent;        @headers['HTTP_USER_AGENT']      end

  def accept=(value);            @headers['HTTP_ACCEPT']=value          end
  def accept_charset=(value);    @headers['HTTP_ACCEPT_CHARSET']=value  end
  def accept_language=(value);   @headers['HTTP_ACCEPT_LANGUAGE']=value end
  def auth_type=(value);         @headers['AUTH_TYPE']=value            end
  def content_length=(value);    @headers['CONTENT_LENGTH']=value       end
  def content_type=(value);      @headers['CONTENT_TYPE']=value         end
  def from=(value);              @headers['HTTP_FROM']=value            end
  def gateway_interface=(value); @headers['GATEWAY_INTERFACE']=value    end
  def path_info=(value);         @headers['PATH_INFO']=value            end
  def path_translated=(value);   @headers['PATH_TRANSLATED']=value      end
  def query_string=(value);      @headers['QUERY_STRING']=value         end
  def raw_cookie=(value);        @headers['HTTP_COOKIE']=value          end
  def referer=(value);           @headers['HTTP_REFERER']=value         end
  def remote_addr=(value);       @headers['REMOTE_ADDR']=value          end
  def remote_host=(value);       @headers['HTTP_HOST']=value            end
  def remote_ident=(value);      @headers['REMOTE_IDENT']=value         end
  def remote_user=(value);       @headers['REMOTE_USER']=value          end
  def request_method=(value);    @headers['REQUEST_METHOD']=value       end
  def script_name=(value);       @headers['SCRIPT_NAME']=value          end
  def server_name=(value);       @headers['SERVER_NAME']=value          end
  def server_port=(value);       @headers['SERVER_PORT']=value          end
  def server_protocol=(value);   @headers['SERVER_PROTOCOL']=value      end
  def server_software=(value);   @headers['SERVER_SOFTWARE']=value      end
  def uri=(value);               @headers['REQUEST_URI']=value          end
  def user_agent=(value);        @headers['HTTP_USER_AGENT']=value      end

  alias url uri
  alias url= uri=

end

end
