module CGIKit

  module RSS

    class Channel < DynamicElement
      include Utilities

      class << self

        def create_api
          api = API.new(:Channel)
          title = Binding.new(:title)
          link = Binding.new(:link)
          description = Binding.new(:description)
          language = Binding.new(:language)
          date = Binding.new(:date)
          api << title
          api << link
          api << description
          api << language
          api << date
          api
        end

      end

      def append_to_response( response, context )
        take_value(:title)
        take_value(:link)
        take_value(:description)
        take_value(:language)
        take_value(:date)

        str = "<channel rdf:about=\"#{@values[:link]}\">"
        str << "<title>#{escape_html(@values[:title])}</title>"
        str << "<link>#{@values[:link]}</link>"
        if @values[:description] then
          str << "<description>#{escape_html(@values[:description])}</description>"
        end
        if @values[:language] then
          str << "<language>#{@values[:language]}</language>"
        end
        if @values[:date] then
          date = @values[:date].utc.strftime("%Y-%m-%dT%H:%M:%S+00:00")
          str << "<dc:date>#{date}</dc:date>"
        end
        response.content << str
        unless empty? then
          @node.append_to_response(response, context)
        end
        response.content << "</channel>"
      end

    end

  end

end
