module CGIKit::RSS

  class RSSRequestHandler < CGIKit::DirectActionRequestHandler

    KEY = 'rss'

    def self.request_handler_key
      KEY
    end

    def handle_request( request )
      direct_action, action_name = action_and_action_name(request)

      result = nil
      @application.synchronize do
        result = direct_action.perform_action(action_name)
        if String === result then
          response = CGIKit::Response.new
          response.content = result.to_s
          result = response
        elsif !result.respond_to?(:generate_response) then
          raise ActionResultError, \
          "Direct action must return an object has generate_response()" +
            " and not nil. - #{direct_action.class}##{action_name}"
        end
        response = result.generate_response
      end

      response.headers['Content-Type'] = 'application/xml'
      response
    end

    def rss_action_url( context, action_class, action_name )
      action_class ||= default_action_class()
      path = action_path(action_class, action_name)
      url(context, path, {}, false, nil, false)
    end

    def default_action_class
      @application.rss_action_class || RSSAction
    end

  end

end


module CGIKit

  class Context

    def rss_action_url( action_class = nil, action_name = 'default' )
      action_class ||= @application.rss_action_class || CGIKit::RSS::RSSAction
      handler = @application.request_handler(RSS::RSSRequestHandler.request_handler_key)
      handler.rss_action_url(self, action_class, action_name)
    end

  end


  class Application

    attr_accessor :rss_action_class

  end

end

CGIKit::RSS::RSSRequestHandler.register

