module CGIKit

  module RSS

    class ItemGroup < DynamicElement
      include Utilities

      class << self

        def create_api
          api = API.new(:ItemGroup)
          title = Binding.new(:title)
          link = Binding.new(:link)
          description = Binding.new(:description)
          date = Binding.new(:date)
          version = Binding.new(:version)
          version.default = 1.0
          api << title
          api << link
          api << description
          api << date
          api << version
          api << list_binding(false)
          api << item_binding()
          api
        end

      end

      def append_to_response( response, context )
        take_value(:list)
        take_value(:version)

        str = '<items><rdf:Seq>'
        if list = @values[:list] then
          list.each do |item|
            set_value(:item, item)
            take_value(:link)
            str << "<rdf:li resource=\"#{@values[:link]}\"/>"
          end
        end
        str << '</rdf:Seq></items>'

        if list then
          list.each do |item|
            set_value(:item, item)
            take_value(:title)
            take_value(:link)
            take_value(:description)
            take_value(:date)

            str << "<item rdf:about=\"#{@values[:link]}\">"
            str << "<title>#{escape_html(@values[:title])}</title>"
            str << "<link>#{@values[:link]}</link>"
            if @values[:description] then
              str << "<description>#{escape_html(@values[:description])}</description>"
            end
            if @values[:date] then
              date = @values[:date].utc.strftime("%Y-%m-%dT%H:%M:%S+00:00")
            end
            str << "<dc:date>#{date}</dc:date>" if date
            str << "</item>"
          end
        end

        response.content << str
      end

    end

  end

end
