require 'fileutils'

def mkdir_p( dir )
  $stderr.puts "mkdir -p #{dir}"
  FileUtils.makedirs(dir)
end

def cp_r( from, to )
  $stderr.puts "cp -r #{from} #{to}"
  FileUtils.cp_r(from, to)
end

docroot = config('docroot')
unless File.exist?(docroot) and FileTest.directory?(docroot) then
  raise "  Document root '#{docroot}' is not existed or directory. Please specify --docroot."
end

wspkg = File.join(docroot, 'cgikit', 'packages')
mkdir_p(wspkg)

pkg = File.join('data', 'cgikit', 'packages')
Dir.foreach(pkg) do |dir|
  next if /\A\./ === dir
  wsdir = File.join(pkg, dir, 'www')
  if File.exist?(wsdir) then
    wwwdir = File.join(wspkg, dir)
    mkdir_p(wwwdir)
    cp_r(wsdir, wwwdir)
  end
end

