class BrowserPage < CGIKit::Component
	TEST_LIST = ['Ruby', 'Smalltalk', 'Java', 'Prolog', 'Objective-C']
	TEST_LIST_FOR_ESCAPE = ['&TestEscapeForBrowserPage&']
	TEST_ITEM = :item
	TEST_DISPLAY = :"#{TEST_ITEM}.object_id"
	TEST_DEFAULT = 'DefalutValue'
	TEST_VALUE = :"#{TEST_ITEM}.object_id"
	TEST_SELECTIONS = :selections
	TEST_SELECTED_VALUES = :selected_values

	TEST_LIST_AND_ITEM_NAME = 'TestListAndItem'
	TEST_DISPLAY_NAME = 'TestDisplay'
	TEST_DEFAULT_NAME = 'TestDefault'
	TEST_VALUE_NAME = 'TestValue'
	TEST_ESCAPE_NAME = 'TestEscape'
	TEST_SELECTIONS_WITH_INDEX_NAME = 'TestSelectionsWithIndex'
	TEST_SELECTIONS_WITH_VALUE_NAME = 'TestSelectionsWithValue'
	TEST_SELECTED_VALUES_WITH_INDEX_NAME = 'TestSelectedValuesWithIndex'
	TEST_SELECTED_VALUES_WITH_VALUE_NAME = 'TestSelectedValuesWithValue'
	TEST_ENABLED_NAME = 'TestEnabled'
	TEST_MULTIPLE_TRUE_NAME = 'TestMultipleTrue'
	TEST_MULTIPLE_FALSE_NAME = 'TestMultipleFalse'

	def self.test_list_and_item( command )
		select = command.element(TEST_LIST_AND_ITEM_NAME)
		select.options.each_with_index do |option, index|
			unless TEST_LIST[index].to_s == option.content then
				return false
			end
		end
		true
	end

	def self.test_display( command )
		select = command.element(TEST_DISPLAY_NAME)
		select.options.each_with_index do |option, index|
			unless TEST_LIST[index].object_id.to_s == option.content then
				return false
			end
		end
		true
	end

	def self.test_escape( command )
		select = command.element(TEST_ESCAPE_NAME)
		select.options.each_with_index do |option, index|
			if TEST_LIST_FOR_ESCAPE[index].to_s != option.content then
				return true
			end
		end
		false
	end

	def self.test_value( command )
		select = command.element(TEST_VALUE_NAME)
		select.options.each_with_index do |option, index|
			unless TEST_LIST[index].object_id.to_s == option[:value] then
				return false
			end
		end
		true
	end

end
