class FormPageDirectAction < CGIKit::DirectAction

  TEST_DIRECT_ACTION_OK = 'DirectAction of FormPageDirectAction is ok'

  def formpage_action
    page = page(FormPage)
    page.flag_for_direct_action = TEST_DIRECT_ACTION_OK
    page
  end

  def self.test_direct_action( content )
    /#{TEST_DIRECT_ACTION_OK}/ === content
  end

end


class FormPage < CGIKit::Component

  TEST_ENCTYPE = 'multipart/form-data'
  TEST_METHOD = 'GET'
  TEST_QUERY = {'key'=>'value', 'value'=>'key'}
  TEST_HREF = 'dummy.cgi'
  TEST_UPLOAD = true
  TEST_ACTION = 'form_action'
  TEST_SUBMIT_WITH_ACTION = 'submit_action'
  TEST_DIRECT_ACTION = 'formpage'
  TEST_ACTION_CLASS = FormPageDirectAction

  TEST_ENCTYPE_NAME = 'TestEnctype'
  TEST_METHOD_NAME = 'TestMethod'
  TEST_QUERY_NAME = 'TestQuery'
  TEST_HREF_NAME = 'TestHref'
  TEST_UPLOAD_NAME = 'TestUpload'
  TEST_SUBMIT_ACTION_NAME = 'TestSubmitAction'
  TEST_SUBMIT_WITH_ACTION_NAME = 'SubmitWithAction'
  TEST_FORM_ACTION_NAME = 'TestFormAction'
  TEST_SUBMIT_WITHOUT_ACTION_NAME = 'SubmitWithoutAction'
  TEST_DIRECT_ACTION_NAME = 'TestDirectAction'
  TEST_ACTION_CLASS_NAME = 'TestActionClass'
  TEST_SUBMIT_DIRECT_ACTION_NAME = 'SubmitDirectAction'

  FLAG_FOR_FORM_ACTION = 'FlagForFormAction'
  FLAG_FOR_SUBMIT_ACTION = 'FlagForSubmitAction'

  def form_action
    @flag_for_form_action = FLAG_FOR_FORM_ACTION
  end

  def submit_action
    @flag_for_submit_action = FLAG_FOR_SUBMIT_ACTION
  end

  def self.test_enctype( command )
    command.form(FormPage::TEST_ENCTYPE_NAME)[:enctype] == TEST_ENCTYPE
  end

  def self.test_method( command )
    command.form(FormPage::TEST_METHOD_NAME)[:method] == TEST_METHOD
  end

  def self.test_query( command )
    form = command.form(FormPage::TEST_QUERY_NAME)
    TEST_QUERY.each do |key, value|
      unless form.hidden(key)[:value] == value.to_s then
        return false
      end
    end
    true
  end

  def self.test_href( command )
    command.form(FormPage::TEST_HREF_NAME)[:action] == TEST_HREF
  end

  def self.test_upload( command )
    command.form(FormPage::TEST_UPLOAD_NAME)[:enctype] == CGIKit::Form::MULTIPART_FORM_DATA
  end

  def self.test_submit_action( content )
    (/#{FLAG_FOR_SUBMIT_ACTION}/ === content) and \
    !(/#{FLAG_FOR_FORM_ACTION}/ === content)
  end

  def self.test_form_action( content )
    !(/#{FLAG_FOR_SUBMIT_ACTION}/ === content) and \
    (/#{FLAG_FOR_FORM_ACTION}/ === content)
  end

end
