class LinkPageDirectAction < CGIKit::DirectAction

  TEST_DIRECT_ACTION_OK = 'DirectAction of LinkPageDirectAction is ok'

  def linkpage_action
    page = page(LinkPage)
    page.flag_string = TEST_DIRECT_ACTION_OK
    page
  end

  def self.test_direct_action( content )
    /#{TEST_DIRECT_ACTION_OK}/ === content
  end

end


class LinkPage < CGIKit::Component

  TEST_ACTION = 'action'
  TEST_PAGE = StringPage
  TEST_HREF = 'http://www.google.co.jp/'
  TEST_STRING = 'LinkPage::TestString'
  TEST_QUERY = {'key'=>'value', 'cgikit'=>'tapkit'}
  TEST_ESCAPE = '&TestEscapeForLinkPage&'
  TEST_DIRECT_ACTION = 'linkpage'
  TEST_ACTION_CLASS = LinkPageDirectAction

  TEST_ACTION_NAME = 'TestAction'
  TEST_PAGE_NAME = 'TestPage'
  TEST_HREF_NAME = 'TestHref'
  TEST_STRING_NAME = 'TestString'
  TEST_SECURE_NAME = 'TestSecure'
  TEST_QUERY_NAME = 'TestQuery'
  TEST_ESCAPE_NAME = 'TestEscape'
  TEST_DIRECT_ACTION_NAME = 'TestDirectAction'
  TEST_ACTION_CLASS_NAME = 'TestActionClass'
  TEST_ENABLED_NAME = 'TestEnabled'

  TEST_ACTION_OK = 'Action of LinkPage is ok'
  TEST_QUERY_OK = /(key=value;cgikit=tapkit|cgikit=tapkit;key=value)/

  attr_accessor :flag_string

  def action
    @flag_string = TEST_ACTION_OK
  end

  def self.test_action( content )
    /#{TEST_ACTION_OK}/ === content
  end

  def self.test_query( link )
    TEST_QUERY_OK === link[:href]
  end

  def self.test_string( link )
    link.content == TEST_STRING
  end

  def self.test_href( link )
    link[:href] == TEST_HREF
  end

  def self.test_secure( link )
    /https:/ === link[:href]
  end

end

