# value, empty, escape
class StringPage < CGIKit::Component

	TEST_VALUE = 'value is ok'
	TEST_UNESCAPED = '<escape>'
	TEST_ESCAPED = '&lt;escape&gt;'
	TEST_EMPTY = 'empty string'
	TEST_BR = "line1\nline2\nline3\n"

	TEST_VALUE_KEY = 'TestValue'
	TEST_EMPTY_KEY = 'TestEmpty'
	TEST_ESCAPE_ON_KEY = 'TestEscapeOn'
	TEST_ESCAPE_OFF_KEY = 'TestEscapeOff'

	def self.test_value( content )
		/#{TEST_VALUE_KEY}:#{TEST_VALUE}/ === content
	end

	def self.test_escape_on( content )
		/#{TEST_ESCAPE_ON_KEY}:#{TEST_ESCAPED}/ === content
	end

	def self.test_escape_off( content )
		/#{TEST_ESCAPE_OFF_KEY}:#{TEST_UNESCAPED}/ === content
	end

	def self.test_empty( content )
		/#{TEST_EMPTY_KEY}:#{TEST_EMPTY}/ === content
	end

	def self.test_br( content )
		/<br \/>/ === content
	end
end
