class TestApp < CGIKit::Application
	include CGIKit

	attr_accessor :did_session_creation_error, :did_session_restoration_error, :did_page_restoration_error, :did_handle_error

	def init
		@component_path = 'TestApp'
		@interface = Adapter::Template
		@error_page = 'TestErrorPage'
	end

	def sample_image_path
		File.join(@web_server_resources, TestCommon::SAMPLE_IMAGE)
	end

	def sample_image_data
		ByteData.new_with_file(sample_image_path())
	end

	def handle_error( error, context )
		@did_handle_error = true
		super
	end

	def handle_session_creation_error( error, context )
		@did_session_creation_error = true
		super
	end

	def handle_session_restoration_error( error, context )
		@did_session_restoration_error = true
		super
	end

	def handle_page_restoration_error( error, context )
		@did_page_restoration_error = true
		super
	end

end
