require 'test/unit'
require 'aop/aop'

class FooAspect < CGIKit::Aspect
  
  advice :a
  
  def a(*args)
    $result[:a] = "123"
    obj = yield
    obj 
  end
  
end

class BarAspect < CGIKit::Aspect
  
  advice :a, :b
  
  def a
    $result[:a] = $result[:a].to_s + 'Bar'
    yield
  end
  
    
  def b(*args)
    $result[:b] = args
    a = yield
    a
  end
  
end


class Hoge
  
  def a
    456
  end
  
  def b(i)
    i
  end
  
  def c(i,j)
    [i,j].collect{|i| i.to_s + 'a'}
  end
  
  def d(i = 0, j = 1, k = 2, *l)
    [i, j, k, l]
  end
  
  def e(num)
    for i in (0..num)
      yield i
    end
    num
  end
  
end

class Hoge
  include_aspect FooAspect, {:a => /^[abcde]$/}
end


# extend_aspect
class Fuga
  
  def f
    456
  end
  
  def g(i)
    i * 2
  end
  
end

class Buga
  
  def i
    []
  end
  
  include_aspect BarAspect, {:a => /^i$/}
  include_aspect FooAspect, {:a => /^i$/, :b => proc{|method| false }}
  
end


class Boga
  
  def j
    {}
  end
  
  include_aspect BarAspect, {:a => /^j$/, :b => [:j]}
  
end

class ErrorAspect < CGIKit::Aspect
  
  advice :a, :b
  
  def b
    
  end
  
end



#######################################
# Test                                #
#######################################

class TestAOP < Test::Unit::TestCase
  
  def setup
    $result = {}
    @h = Hoge.new
  end
  
  def test_Hoge_a
    assert_equal(456, @h.a)
    assert_equal("123", $result[:a]) 
  end
  
  def test_Hoge_b
    assert_equal('abc', @h.b('abc'))
    assert_equal("123", $result[:a]) 
  end
  
  def test_Hoge_c
    assert_equal(['aa', '3a'], @h.c('a', 3))
    assert_equal("123", $result[:a]) 
  end
  
  def test_Hoge_d
    assert_equal( [nil, true, false, [[], {}]] , @h.d(nil, true, false, [], {}))
    assert_equal("123", $result[:a]) 
  end
  
  def test_Hoge_e
    j = 0
    result = @h.e(10){|i|
      assert_equal(j, i)
      j += 1
    }
    
    assert_equal(10, result)
    assert_equal("123", $result[:a]) 
  end
  
  def test_Fuga_f
    f = Fuga.new
    f.extend_aspect(FooAspect, /^f/)

    assert_equal(false, f.respond_to?(:a))
    assert_equal(false, f.respond_to?(:b))    
    assert_equal(456, f.f)
    assert_equal('123', $result[:a])
  end
    
  def test_Fuga_g
    f = Fuga.new
    f.extend_aspect(FooAspect, {:a => [:g] })
    
    assert_equal(false, f.respond_to?(:a))
    assert_equal(false, f.respond_to?(:b))
    assert_equal(2, f.g(1))
    assert_equal('123', $result[:a])
  end
  
  def test_Buga_i
    b = Buga.new
    assert_equal([], b.i)
    assert_equal('123Bar', $result[:a]) 
  end
  
  def test_Boga_j
    h = Boga.new
    assert_equal({}, h.j)
    assert_equal('Bar', $result[:a]) 
    assert_equal(["j"], $result[:b]) 
  end
  
  def test_Error_aspect
    h = Class.new
    assert_raises(CGIKit::Aspect::AspectError) {
      h.__send__(:include_aspect, ErrorAspect, {})
    }
  end
  
end
