if __FILE__ == $0 then
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'TestApp/app'
	require 'TestApp/EmptyPage/EmptyPage'
	require 'test_common'
end

# new_with_keypath, new_with_value
# constant?(component=nil), settable?(component=nil)
# set_value(value, component), value(component)

class TestAssociation < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = EmptyPage
	end

	def test_new
		keypath = 'obj.key'
		as = Association.new_with_keypath keypath
      assert_equal(keypath, as.keypath)
		assert_equal(false, as.constant?)
		assert_equal(true, as.settable?)

		value = 'string'
		as = Association.new_with_value value
      assert_equal(value, as.value(nil))
		assert_equal(true, as.constant?)
		assert_equal(false, as.settable?)
	end

	def test_set_value
		value = 'string'
		keypath = 'strkey'
		component = @app.run.component
		as = Association.new_with_keypath(keypath)
		as.set_value(value, component)
		assert_equal(value, as.value(component))
	end

	def test_constant
		value = 'string'
		keypath = 'strkey'
		component = @app.run.component

		as = Association.new_with_keypath(keypath)
		assert_nothing_raised do
			as.set_value(value, component)
		end

		as = Association.new_with_value(value)
		assert_raises(Association::InternalInconsistencyError) do
			as.set_value(value, component)
		end
	end
end



if __FILE__ == $0 then
	suite = TestAssociation.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
