module TestCommon
  include CGIKit

  TESTAPP = 'TestApp'

  TEST_ATTR_KEY = :test_attr_key
  TEST_ATTR_VALUE = 'TestAttrValue'
  TEST_OTHER_KEY = :TestOtherValue
  TEST_OTHER_VALUE = 'other'
  TEST_OTHER = "#{TEST_OTHER_KEY}=\"#{TEST_OTHER_VALUE}\""

  TEST_OTHER_NAME = 'TestOtherName'

  TMPDIR = 'tmp'
  WEB_SERVER_RESOURCES_PATH = 'wsresources'
  SAMPLE_IMAGE = 'cgikit.png'

  attr_accessor :does_test_other

  def testapp
    app = TestApp.new
    app.adapter_class = Adapter::Template
    app.component_path = "./#{TESTAPP}"
    app.tmpdir = TMPDIR
    app.document_root = File.join(Dir.pwd, TESTAPP)
    app.web_server_resource_path = "./#{TESTAPP}/#{WEB_SERVER_RESOURCES_PATH}"
    app.cache_template = false
    app
  end

  def test_other
    if @does_test_other then
      response = @app.run
      command = Command.new(response)
      assert(TestCommon.test_other(command))
    end
  end

  def self.tmp_resource_dir
    File.join(TMPDIR, ResourceManager::TMPDIR)
  end

  def self.test_other( command )
    control = command.element(TEST_OTHER_NAME)
    (control[TEST_ATTR_KEY] == TEST_ATTR_VALUE) and \
      (control[TEST_OTHER_KEY] == TEST_OTHER_VALUE)
  end

  def self.test_other_declaration( klass, hash = {} )
    dec = {
      :element => klass,
      :name => TEST_OTHER_NAME,
      TestCommon::TEST_ATTR_KEY => TestCommon::TEST_ATTR_VALUE,
      :other => TestCommon::TEST_OTHER
    }
    dec.update(hash)
    dec
  end

end


module DirectActionAPITesting
  include CGIKit

  attr_accessor :direct_action_element

  def test_api_direct_action_with_action_class
    dec = {:TestAPI => {:element=>@direct_action_element,
                        :direct_action=>'default',
                        :action_class=>DirectAction}}
    store = DeclarationStore.new_from_hash(dec)
    assert_nothing_raised { store.validate_api }
  end

  def test_api_direct_action_without_action_class
    dec = {:TestAPI => {:element=>@direct_action_element,
                        :direct_action=>'default'}}
    store = DeclarationStore.new_from_hash(dec)
    assert_nothing_raised { store.validate_api }
  end

end

