if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/StringPage/StringPage'
	require 'TestApp/GenericElementPage/GenericElementPage'
	require 'test_common'
end


class TestElementGenericElement < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = GenericElementPage
		@does_test_other = true
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>GenericElement}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_form_value_and_form_values_bound
		dec = {:TestAPI => {:element=>GenericElement, :tag=>:tag, :form_value=>:test, :form_values=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_current_bound
		dec = {:TestAPI => {:element=>GenericElement, :tag=>:tag, :form_value=>:test, :invoke_action=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_tag
		response = @app.run
		command = Command.new(response)
		element = command.element(GenericElementPage::TEST_TAG_NAME)
		assert_kind_of(Command::HTMLLink, element)
	end

	def test_displayed
		response = @app.run
		command = Command.new(response)
		assert_nil(command.element(GenericElementPage::TEST_DISPLAYED_NAME))
	end

	def test_invoke_action_with_link
		response = @app.run
		command = Command.new(response)
		command.link(GenericElementPage::TEST_ACTION_WITH_LINK_NAME).submit
		response = @app.run(command)
		pattern = /#{GenericElementPage::TEST_ACTION_WITH_LINK_OK}/
		assert_match(pattern, response.content)
	end

	def test_invoke_action_with_button
		response = @app.run
		command = Command.new(response)
		command.submit(GenericElementPage::TEST_ACTION_WITH_BUTTON_NAME).submit
		response = @app.run(command)
		pattern = /#{GenericElementPage::TEST_ACTION_WITH_BUTTON_OK}/
		assert_match(pattern, response.content)
	end

	def test_form_value
		expected = 'test form value'
		response = @app.run
		command = Command.new(response)
		textfield = command.element(GenericElementPage::TEST_FORM_VALUE_NAME)
		textfield[:value] = expected
		command.submit(GenericElementPage::TEST_ACTION_WITH_BUTTON_NAME).submit

		response = @app.run(command)
		command = Command.new(response)
		textfield = command.element(GenericElementPage::TEST_FORM_VALUE_NAME)
		assert_equal(expected, textfield[:value])
		assert_equal(expected, response.component.value_for_key(GenericElementPage::TEST_FORM_VALUE))

	end

	def test_form_values
		expected = 'test form values'
		response = @app.run
		command = Command.new(response)
		textfield = command.element(GenericElementPage::TEST_FORM_VALUES_NAME)
		textfield[:value] = expected
		command.submit(GenericElementPage::TEST_ACTION_WITH_BUTTON_NAME).submit

		response = @app.run(command)
		command = Command.new(response)
		textfield = command.element(GenericElementPage::TEST_FORM_VALUES_NAME)
		assert_equal(expected, textfield[:value])
		assert_equal([expected], response.component.value_for_key(GenericElementPage::TEST_FORM_VALUES))
	end
end


if __FILE__ == $0 then
	suite = TestElementGenericElement.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
