if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/ImagePage/ImagePage'
	require 'test_common'
end


class TestElementImage < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = ImagePage
		@does_test_other = true
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>Image}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_either_file_or_src_or_data_bound
		dec = {:TestAPI => {:element=>Image, :file=>:test, :data=>:test, :src=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_file_bound
		dec = {:TestAPI => {:element=>Image, :file=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_src_bound
		dec = {:TestAPI => {:element=>Image, :src=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_data_and_mime_bound
		dec = {:TestAPI => {:element=>Image, :data=>:test, :mime=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_file_bound
		response = @app.run
		command = Command.new(response)
		assert(ImagePage.test_file(command))
	end

	def test_src_bound
		response = @app.run
		command = Command.new(response)
		assert(ImagePage.test_src(command))
	end

	def test_data_bound
		response = @app.run
		command = Command.new(response)
		assert(ImagePage.test_data(command))
	end

end


if __FILE__ == $0 then
	suite = TestElementImage.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
