if __FILE__ == $0
  $LOAD_PATH.unshift '../lib' 
  require 'test/unit'
  require 'test/unit/ui/console/testrunner'
  require 'cgikit'
  require 'cgikit/command'
  require 'TestApp/app'
  require 'TestApp/RadioPage/RadioPage'
  require 'test_common'
end


class TestElementRadio < Test::Unit::TestCase
  include CGIKit, TestCommon

  def setup
    @app = testapp()
    @app.main = RadioPage
    @does_test_other = true
  end

  def test_api_checked
    dec = {:TestAPI => {:element=>Radio, :checked=>:test}}
    store = DeclarationStore.new_from_hash(dec)
    assert_nothing_raised { store.validate_api }
  end

  def test_api_value_and_selection
    dec = {:TestAPI => {:element=>Radio, :value=>:test, :selection=>:test}}
    store = DeclarationStore.new_from_hash(dec)
    assert_nothing_raised { store.validate_api }

    dec = {:TestAPI => {:element=>Radio, :value=>:test}}
    store = DeclarationStore.new_from_hash(dec)
    assert_raises(ValidationError) { store.validate_api }

    dec = {:TestAPI => {:element=>Radio, :selection=>:test}}
    store = DeclarationStore.new_from_hash(dec)
    assert_raises(ValidationError) { store.validate_api }
  end

  def test_api_nothing_bound
    dec = {:TestAPI => {:element => Radio}}
    store = DeclarationStore.new_from_hash(dec)
    assert_raises(ValidationError) { store.validate_api }
  end

  def test_value_and_selection
    response = @app.run
    command = Command.new(response)
    command.control(RadioPage::TEST_VALUE_AND_SELECTION_NAME).checked = true
    command.form_at(0).submit_form
    response = @app.run(command)
    assert_equal(RadioPage::TEST_VALUE, response.component.selection)

    command = Command.new(response)
    command.control(RadioPage::TEST_VALUE_AND_SELECTION_NAME).checked = false
    command.form_at(0).submit_form
    response = @app.run(command)
    assert_nil(response.component.selection)
  end

  def test_checked
    response = @app.run
    command = Command.new(response)
    command.control(RadioPage::TEST_CHECKED_NAME).checked = true
    command.form_at(0).submit_form
    response = @app.run(command)
    assert_equal(true, response.component.checked)

    command = Command.new(response)
    command.control(RadioPage::TEST_CHECKED_NAME).checked = false
    command.form_at(0).submit_form
    response = @app.run(command)
    assert_equal(false, response.component.checked)
  end

  def test_enabled
    response = @app.run()
    command = Command.new(response)
    control = command.control(RadioPage::TEST_ENABLED_NAME)
    assert_equal(RadioPage::TEST_ENABLED, control.enabled?)
  end
end


if __FILE__ == $0 then
  suite = TestElementRadio.suite
  runner = Test::Unit::UI::Console::TestRunner.new suite
  runner.start
end
