if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/RepetitionPage/RepetitionPage'
	require 'test_common'
end


class TestElementRepetition < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = RepetitionPage
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element=>Repetition}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_count_and_list_bound
		dec = {:TestAPI => {:element=>Repetition, :count=>:test, :list=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_count_bound
		dec = {:TestAPI => {:element=>Repetition, :count=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_list_bound
		dec = {:TestAPI => {:element=>Repetition, :list=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_list
		response = @app.run
		assert(RepetitionPage.test_list(response.content))
	end

	def test_count
		response = @app.run
		assert(RepetitionPage.test_count(response.content))
	end

end


if __FILE__ == $0 then
	suite = TestElementRepetition.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
